package ru.yandex.chemodan.app.eventloader;

import java.net.URI;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.disksearch.indexing.EventIndexer;
import ru.yandex.chemodan.disksearch.indexing.EventIndexerImpl;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
public class EventIndexerContextConfiguration {

    @Bean
    public EventIndexer indexer(
            @Value("${indexer.uri}") URI indexUri, HttpClient indexerHttpClient)
    {
        return new EventIndexerImpl(indexerHttpClient, indexUri);
    }

    @Bean
    public HttpClient indexerHttpClient() {
        return indexerHttpConfigurator().configure();
    }

    @Bean
    @OverridableValuePrefix("indexer")
    public HttpClientConfigurator indexerHttpConfigurator() {
        return new HttpClientConfigurator();
    }
}
