package ru.yandex.chemodan.app.eventloader;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.eventlog.celery.QuellerFallbackEventsLogListener;
import ru.yandex.chemodan.queller.worker.BazingaStubContextConfiguration;
import ru.yandex.chemodan.queller.worker.CeleryJavaWorkerContextConfiguration;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTask;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.chemodan.queller.worker.CeleryTaskManagerContextConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import({
        EventLoaderLogListenerConfig.class,
        BazingaStubContextConfiguration.class,
        CeleryJavaWorkerContextConfiguration.class,
        CeleryTaskManagerContextConfiguration.class,
})
public class EventLoaderCeleryContextConfiguration {
    @Autowired
    private EventLoaderLogListener eventLoaderLogListener;

    @Autowired
    private CeleryTaskManager celeryTaskManager;

    @Value("${queller.retry.count}")
    private int retryCount;

    @Bean
    @Primary
    public QuellerFallbackEventsLogListener quellerFallbackEventsLogListener() {
        return new QuellerFallbackEventsLogListener(eventLoaderLogListener, celeryTaskManager, retryCount,
                EventLoaderCeleryTask::new
        );
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues() {
        return new BazingaWorkerTaskQueues(
                Option.empty(),
                Option.empty(),
                Option.empty(),
                Cf.list(new TaskQueue(CeleryOnetimeTask.BAZINGA_QUEUE_NAME, 1, 0))
        );
    }

    @Bean
    public EventLoaderCeleryTask eventLoaderCeleryTask() {
        return new EventLoaderCeleryTask(eventLoaderLogListener);
    }
}
