package ru.yandex.chemodan.app.eventloader;

import ru.yandex.chemodan.eventlog.celery.CeleryLogLineUtils;
import ru.yandex.chemodan.eventlog.celery.ProcessLogLineCeleryTask;
import ru.yandex.chemodan.eventlog.log.TskvLogLine;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.commune.bazinga.impl.TaskId;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class EventLoaderCeleryTask extends ProcessLogLineCeleryTask<EventLoaderLogListener> {
    public EventLoaderCeleryTask(EventLoaderLogListener listener) {
        super(listener);
    }

    public EventLoaderCeleryTask(String logLine) {
        super(CeleryLogLineUtils.toCeleryOneTimeTaskParameters(TskvLogLine.parse(logLine)));
    }

    @Override
    protected TaskId celeryTaskId() {
        return new TaskId("event-loader.process_log_line");
    }

    @Override
    protected String toLogLine(CeleryOnetimeTaskParameters celeryOnetimeTaskParameters) {
        return CeleryLogLineUtils.toTskvLogLine(celeryOnetimeTaskParameters);
    }
}
