package ru.yandex.chemodan.app.eventloader;

import org.springframework.context.ConfigurableApplicationContext;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.boot.ChemodanPropertiesLoadStrategy;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.chemodan.test.TestHelper;
import ru.yandex.misc.main.MainSupport;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.property.eval.PropertyPlaceholderConfigurer2;
import ru.yandex.misc.property.load.strategy.PropertiesLoadStrategy;
import ru.yandex.misc.spring.ApplicationContextUtils;
import ru.yandex.misc.version.AbstractVersion;
import ru.yandex.misc.version.AppName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class EventLoaderConsoleMainSupport extends MainSupport {
    protected abstract AppName applicationName();

    @Override
    protected Class[] applicationContextPath() {
        return Cf.<Class>list()
                .plus(EventLoaderLogListenerConfig.class)
                .toArray(Class.class);
    }

    @Override
    protected void configureLogger() {
        TestHelper.initialize();
    }

    @Override
    protected void postProcessApplicationContextBeforeRefresh(ConfigurableApplicationContext context) {
        super.postProcessApplicationContextBeforeRefresh(context);
        ApplicationContextUtils.registerSingleton(context, "appName", applicationName());
        ApplicationContextUtils.registerSingleton(context, "appVersion", getVersion());
        ApplicationContextUtils.registerSingleton(context, "propertyPlaceholderConfigurer2",
                propertyPlaceholderConfigurer2());

    }

    private PropertyPlaceholderConfigurer2 propertyPlaceholderConfigurer2() {
        final PropertyPlaceholderConfigurer2 configurer2 = new PropertyPlaceholderConfigurer2();
        configurer2.setProperties(PropertiesHolder.properties());
        return configurer2;
    }

    @Override
    protected PropertiesLoadStrategy propertiesLoadStrategy() {
        return new ChemodanPropertiesLoadStrategy(applicationName(), false);
    }

    @Override
    protected AbstractVersion getVersion() {
        return DiskAppVersion.VERSION;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public boolean isStartServices() {
        return false;
    }
}
