package ru.yandex.chemodan.app.eventloader;

import java.util.concurrent.ThreadPoolExecutor;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.logbroker.DiskLbConsumerContextConfiguration;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.inside.logbroker.pull.consumer.LbSimpleAsyncLineListener;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import({
        EventLoaderLogListenerConfig.class,
        EventLoaderCeleryContextConfiguration.class,
        DiskLbConsumerContextConfiguration.class,
        A3JettyContextConfiguration.class,
})
public class EventLoaderContextConfiguration {
    @Autowired
    @Qualifier("lbListenerExecutor")
    private ThreadPoolExecutor listenerExecutor;

    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.arrayList()) {
            @Override
            public void postConstruct(SingleWarJetty jetty, ActionApp actionApp) {
                jetty.setMaxFormContentSize((int) DataSize.fromMegaBytes(100).toBytes());
            }
        };
    }

    @Bean
    public LbSimpleAsyncLineListener lbConsumerListener(LogListener logListener) {
        return new LbSimpleAsyncLineListener(logListener, listenerExecutor);
    }
}
