package ru.yandex.chemodan.app.eventloader;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.disksearch.indexing.EventIndexer;
import ru.yandex.chemodan.disksearch.indexing.EventIndexerStub;
import ru.yandex.chemodan.disksearch.indexing.RejectIndexDocumentMatcherHolder;
import ru.yandex.chemodan.eventlog.events.EventMetadata;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.commune.dynproperties.DynamicPropertiesContextConfiguration;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import({
        DynamicPropertiesContextConfiguration.class,
        EventIndexerContextConfiguration.class,
})
public class EventLoaderLogListenerConfig {
    @Bean
    public EventLoaderLogListener eventLoaderLogListener(EventIndexer indexer, MpfsClient mpfsClient) {
        return new EventLoaderLogListener(indexer, mpfsClient, 3);
    }


    @Autowired
    private DynamicPropertyManager dynamicPropertyManager;

    @PostConstruct
    public void init() {
        dynamicPropertyManager.addStaticFields(EventMetadata.class);
        dynamicPropertyManager.addStaticFields(EventLoaderLogListener.class);
        dynamicPropertyManager.addStaticFields(EventIndexerStub.class);
        RejectIndexDocumentMatcherHolder.register(dynamicPropertyManager);
    }
}
