package ru.yandex.chemodan.app.eventloader.serializer;

import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.simpleType.SimpleTypeMarshallerSupport;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MpfsUidMarshaller extends SimpleTypeMarshallerSupport {
    @Override
    protected String toStringValueForXml(Object o) {
        return getStringValue(o);
    }

    @Override
    protected void writeJson(BenderJsonWriter benderJsonWriter, Object o) {
        benderJsonWriter.writeString(getStringValue(o));
    }

    private String getStringValue(Object o) {
        return ((MpfsUid) o).getRawValue();
    }
}
