package ru.yandex.chemodan.app.eventloader.utils;

import java.io.IOException;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.eventloader.EventLoaderConsoleMainSupport;
import ru.yandex.chemodan.eventlog.events.MpfsAddress;
import ru.yandex.chemodan.eventlog.events.fs.StoreTypeSubtype;
import ru.yandex.chemodan.eventlog.log.TskvEventType;
import ru.yandex.chemodan.mpfs.MpfsUid;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.gzip.GunzipInputStreamSource;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class AnalyzeMain extends EventLoaderConsoleMainSupport {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzeMain.class);

    @Autowired
    private TskvEventLogReader logReader;

    private final SetF<String> services = Cf.hashSet();

    private final SetF<String> specialUids = Cf.hashSet();

    private final SetF<StoreTypeSubtype> storeTypeSubtypes = Cf.hashSet();


    public static void main(String[] args) throws IOException {
        new AnalyzeMain().runMain(args);
    }

    public void run() {
        process(new File2("/Users/lemeh/Downloads/event-history-logs/"));
    }

    private void process(File2 file) {
        if (file.isDirectory()) {
            for(File2 childFile : file.list()) {
                process(childFile);
            }
            return;
        }

        if (!file.getName().matches("mpfs_event-history.log.201509\\d{2}.gz")) {
            return;
        }

        logReader.readAllRaw(new GunzipInputStreamSource(file.asInputStreamTool()), tskv -> {
            SetF<MpfsUid> uids = Cf.<MpfsUid>set()
                    .plus(tskv.getMetadata().uid)
                    .plus(tskv.getAddressO("src_rawaddress").map(address -> address.owner))
                    .plus(tskv.getAddressO("tgt_rawaddress").map(address -> address.owner))
                    .minus1(new MpfsUid("share_production"));

            if (uids.size() > 1) {
                logger.info(tskv);
            }

            TskvEventType eventType = tskv.getEventType();
            if (Cf.list(TskvEventType.FS_STORE, TskvEventType.FS_COPY).containsTs(eventType)) {
                boolean newAddressInfo = saveInfo(tskv.getAddressO("tgt_rawaddress"));
                if (newAddressInfo) {
                    logger.info("services = {}", services);
                    logger.info("special uids = {}", specialUids);
                }
            }

            if (eventType == TskvEventType.FS_STORE) {
                boolean newInfo = saveInfo(tskv.getFsStoreTypes());
                if (newInfo) {
                    logger.info("store types = {}", storeTypeSubtypes);
                }
            }
        });
    }

    private boolean saveInfo(StoreTypeSubtype storeTypeSubtype) {
        return storeTypeSubtype != StoreTypeSubtype.NONE && storeTypeSubtypes.add(storeTypeSubtype);
    }

    private boolean saveInfo(Option<MpfsAddress> addressO) {
        return addressO.isPresent() && saveInfo(addressO.get());
    }

    private boolean saveInfo(MpfsAddress address) {
        boolean newServiceAdded = services.add(address.path.service);
        boolean newUidAdded = false;
        if (address.owner.isSpecial()) {
            newUidAdded = specialUids.add(address.owner.getSpecialUid());
        }
        return newServiceAdded || newUidAdded;
    }

    @Override
    protected AppName applicationName() {
        return new SimpleAppName("disk", "analyze");
    }
}
