package ru.yandex.chemodan.app.eventloader.utils;

import java.io.IOException;
import java.io.OutputStream;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.eventloader.EventLoaderConsoleMainSupport;
import ru.yandex.chemodan.disksearch.indexing.IndexRequest;
import ru.yandex.chemodan.disksearch.indexing.IndexRequestBuilder;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class GenerateExampleJsonMain extends EventLoaderConsoleMainSupport {
    public static void main(String[] args) {
        new GenerateExampleJsonMain().runMain(args);
    }

    public static final String EXAMPLE_LOG_PATH = "ru/yandex/chemodan/eventlog/log/example.log";

    @Autowired
    private TskvEventLogReader logReader;

    @Autowired
    private IndexRequestBuilder<AbstractEvent> serializer;

    protected void run() {
        OutputStream out = System.out;
        logReader.readAll(new ClassPathResourceInputStreamSource(EXAMPLE_LOG_PATH), event -> {
            try {
                for(IndexRequest request : serializer.build(event.getEvents())) {
                    out.write(request.toJson());
                    out.write(",\n".getBytes());
                }
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    protected AppName applicationName() {
        return new SimpleAppName("disk", "generate-example-json");
    }
}
