package ru.yandex.chemodan.app.eventloader.utils;

import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.eventlog.events.AbstractEvent;
import ru.yandex.chemodan.eventlog.log.TskvEventLogLine;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TskvEventLogReader {
    private static final Logger logger = LoggerFactory.getLogger(TskvEventLogReader.class);

    public void readAll(InputStreamSource iss, Function1V<AbstractEvent> eventProcessor) {
        readAllRaw(iss, line -> {
            try {
                eventProcessor.apply(line.toEvent().get());
            } catch(RuntimeException ex) {
                logger.error("While parsing line: {}", line, ex);
            }
        });
    }

    public void readAllRaw(InputStreamSource iss, Function1V<TskvEventLogLine> eventProcessor) {
        readLinesWithNewLineFix(iss, line -> {
            try {
                eventProcessor.apply(parseEvent(line));
            } catch(RuntimeException ex) {
                logger.error("While parsing line: {}", line, ex);
            }
        });
    }

    private TskvEventLogLine parseEvent(String line) {
        try {
            return TskvEventLogLine.parse(line);
        } catch (IllegalArgumentException ex) {
            return TskvEventLogLine.parse(fixBrokenTabInTskvString(line));
        }
    }

    private void readLinesWithNewLineFix(InputStreamSource iss, Function1V<String> function) {
        String line = null;
        for(String nextLine : iss.readLines()) {
            if (line == null) {
                line = nextLine;
                continue;
            }

            if (!nextLine.startsWith("tskv")) {
                line += nextLine;
                continue;
            }

            function.apply(line);

            line = nextLine;
        }
        function.apply(line);
    }

    public static String fixBrokenTabInTskvString(String value) {
        return value.replaceAll("([^\t]+?=[^\t]+?)(\t+)(?=[^=\t]*(?:\t|$))", "$1\\\\t");
    }
}
