package ru.yandex.chemodan.app.fotki;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.fotki.dao.AlbumDao;
import ru.yandex.chemodan.app.fotki.dao.model.Album;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Ilya Rubin
 * @author Ildar Safarov
 */
public class AlbumManager {

    public static final int MAX_ALBUM_DEPTH = 4;

    public static final int FAKE_ROOT_ID = 0; // this is special root id; if tree has root with this id we don't store album for root

    private static final Logger logger = LoggerFactory.getLogger(AlbumManager.class);

    private AlbumDao albumDao;

    public AlbumManager(AlbumDao albumDao) {
        this.albumDao = albumDao;
    }

    /**
     * true if 'travel' to root was successful and false if one of albums wasn't found (don't
     * know if this case is important yet - maybe we should ignore it)
     */
    public ListF<Album> findPathToRootFrom(PassportUid uid, int startFromAlbumId)
    {
        ListF<Album> result = Cf.arrayList();

        if (startFromAlbumId == FAKE_ROOT_ID) {
            return result;
        }

        int albumId = startFromAlbumId;
        int pathToRootCyclesGuard = MAX_ALBUM_DEPTH * 3;
        for (int i = 0; i < pathToRootCyclesGuard; i++) {
            Option<Album> albumO = albumDao.findAlbumById(uid, albumId);
            if (!albumO.isPresent()) {
                return result;
            }

            Album album = albumO.get();
            result.add(album);

            if (album.getParentId() == 0) {
                return result;
            }

            albumId = album.getParentId();
        }

        logger.warn("Traveling to root loop ended because pathToRootCyclesGuard() threshold was reached."
                + " It means that albums contains loop. uid={}; startFromAlbumId={}", uid, startFromAlbumId);

        // shouldn't be reachable in most of cases; in case of loop (in which I personally do not
        // believe) false looks better as it is not normal (the same is loop)
        return result;
    }
}
