package ru.yandex.chemodan.app.fotki;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class AlbumUrlServlet extends AbstractFotkiServlet {

    private static final Logger logger = LoggerFactory.getLogger(AlbumUrlServlet.class);

    private final PhotoProxyManager photoProxyManager;

    @Value("${fotki.promo.url}")
    private String promoUrl;

    public AlbumUrlServlet(PhotoProxyManager photoProxyManager) {
        this.photoProxyManager = photoProxyManager;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String redirectUrl = promoUrl;
        try {
            final Image parsedFromUrl = UrlParser.parseAlbumUrl(req.getPathInfo());
            redirectUrl = photoProxyManager.getAlbum(parsedFromUrl);
        } catch (RuntimeException ex) {
            logger.error(ex.getMessage());
        }
        resp.setStatus(HttpStatus.SC_301_MOVED_PERMANENTLY);
        resp.addHeader("Location", redirectUrl);
    }
}
