package ru.yandex.chemodan.app.fotki;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.fotki.dao.ImageDao;
import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.chemodan.app.fotki.dao.model.ImageFlag;
import ru.yandex.chemodan.util.exception.PermanentHttpFailureException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class BlockPhotoManager {

    private static final Logger logger = LoggerFactory.getLogger(BlockPhotoManager.class);

    private final ImageDao imageDao;

    public BlockPhotoManager(ImageDao imageDao) {
        this.imageDao = imageDao;
    }

    public void blockImage(Image image) {
        final int count = imageDao.updateFlags(image, ImageFlag.BLOCKED.mask(), 0L);
        if (count == 0) {
            logger.error("Could not update flag for image {}", image);
            throw new PermanentHttpFailureException("Image not found", HttpStatus.SC_404_NOT_FOUND);
        }
    }

    public void unblockImage(Image image) {
        final int count = imageDao.updateFlags(image, 0L, ImageFlag.BLOCKED.mask());
        if (count == 0) {
            logger.error("Could not update flag for image {}", image);
            throw new PermanentHttpFailureException("Image not found", HttpStatus.SC_404_NOT_FOUND);
        }
    }

    public void blockImageList(ListF<Image> imageList) {
        final int[] results = imageDao.batchUpdateFlags(imageList, ImageFlag.BLOCKED.mask(), 0L);
        checkResult(imageList, results);
    }

    public void unblockImageList(ListF<Image> imageList) {
        final int[] results = imageDao.batchUpdateFlags(imageList, 0L, ImageFlag.BLOCKED.mask());
        checkResult(imageList, results);
    }

    private void checkResult(ListF<Image> imageList, int[] results) {
        boolean notUpdated = false;
        for (int i = 0; i < results.length; i++) {
            if (results[i] == 0) {
                logger.error("Could not update flag for image {}", imageList.get(i));
                notUpdated = true;
            }
        }
        if (notUpdated) {
            throw new PermanentHttpFailureException("Image not found", HttpStatus.SC_404_NOT_FOUND);
        }
    }
}
