package ru.yandex.chemodan.app.fotki;

import java.io.BufferedReader;
import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.chemodan.util.exception.PermanentHttpFailureException;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;

public class BlockPhotoUrlServlet extends HttpServlet {

    private BlockPhotoManager blockPhotoManager;

    public BlockPhotoUrlServlet(BlockPhotoManager blockPhotoManager) {
        this.blockPhotoManager = blockPhotoManager;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            final Image imageParsed = UrlParser.parseUrl(req.getPathInfo());
            blockPhotoManager.blockImage(imageParsed);
            resp.setStatus(HttpStatus.SC_200_OK);
            resp.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            resp.addHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        } catch (PermanentHttpFailureException ex) {
            resp.setStatus(ex.getStatusCode().get());
        } catch (HttpException ex) {
            resp.setStatus(ex.getStatusCode().get());
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            BufferedReader reader = req.getReader();
            JSONArray jsonArray = new JSONArray(reader.readLine());
            for (int i = 0; i < jsonArray.length(); i++) {
                Image imageParsed = UrlParser.parseUrl(jsonArray.getString(i));
                blockPhotoManager.blockImage(imageParsed);
            }
            resp.setStatus(HttpStatus.SC_200_OK);
            resp.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            resp.addHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        } catch (PermanentHttpFailureException ex) {
            resp.setStatus(ex.getStatusCode().get());
        } catch (HttpException ex) {
            resp.setStatus(ex.getStatusCode().get());
        }
    }

    public void block(String path) {
        final Image imageParsed = UrlParser.parseUrlLenient(path);
        blockPhotoManager.blockImage(imageParsed);
    }

    public void unblock(String path) {
        final Image imageParsed = UrlParser.parseUrlLenient(path);
        blockPhotoManager.unblockImage(imageParsed);
    }

    public void blockList(ListF<String> pathList) {
        final ListF<Image> imageList = pathList.map(UrlParser::parseUrlLenient);
        blockPhotoManager.blockImageList(imageList);
    }

    public void unblockList(ListF<String> pathList) {
        final ListF<Image> imageList = pathList.map(UrlParser::parseUrlLenient);
        blockPhotoManager.unblockImageList(imageList);
    }
}
