package ru.yandex.chemodan.app.fotki;

import java.io.IOException;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.fotki.dao.ImageDao;
import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.chemodan.app.fotki.dao.model.ImageFlag;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.web.servlet.mock.MockHttpServletRequest;
import ru.yandex.misc.web.servlet.mock.MockHttpServletResponse;

import static ru.yandex.misc.db.embedded.ActivateEmbeddedPg.EMBEDDED_PG;

@RunWith(SpringJUnit4ClassRunner.class)
@ActiveProfiles(EMBEDDED_PG)
public class BlockPhotoUrlServletTest extends FotkiAbstractTest {

    @Autowired
    BlockPhotoUrlServlet blockPhotoUrlServlet;

    @Autowired
    ImageDao imageDao;

    @Autowired
    JdbcTemplate3 jdbcTemplate;

    @Test
    public void testDoPost() throws IOException {
        // добавление тестовой картинки
        final String q1 = "INSERT INTO albums(album_id, user_id) values (?, ?)";
        jdbcTemplate.update(q1, 2, 15147017);
        final String q2 = "INSERT INTO images(image_id, dir_name, album_id, user_id, flags) values (?, ?, ?, ?, 0)";
        jdbcTemplate.update(q2, 839775, "28500736.432", 2, 15147017);

        // проверка наличия картинки
        final Image image = Image.builder().imageId(839775).dirName("28500736.432").build();
        Option<Image> found = imageDao.find(image);
        Assert.exists(found, i -> !i.getFlags().isSet(ImageFlag.BLOCKED));

        // блокировка картнки
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/block");
        request.setMethod("POST");
        request.setContentType("application/json");
        request.setContent("['/15147017/28500736.432/2_cd05f_5788b1bd_N']".getBytes());

        MockHttpServletResponse response = new MockHttpServletResponse();
        blockPhotoUrlServlet.doPost(request, response);

        Assert.equals(200, response.getStatus());

        // проверка блокировки картинки
        found = imageDao.find(image);
        Assert.exists(found, i -> i.getFlags().isSet(ImageFlag.BLOCKED));
    }

}
