package ru.yandex.chemodan.app.fotki;

import org.apache.http.client.HttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

@Configuration
public class DownloaderHttpClientContextConfiguration {

    @Bean
    @OverridableValuePrefix("downloader")
    public HttpClientConfigurator downloaderHttpClientConfigurator(){
        return new HttpClientConfigurator();
    }

    @Bean
    public HttpClient downloaderHttpClient(){
        return downloaderHttpClientConfigurator().createBuilder().disableRedirectHandling().build();
    }
}
