package ru.yandex.chemodan.app.fotki;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.fotki.dao.AlbumDao;
import ru.yandex.chemodan.app.fotki.dao.ImageDao;
import ru.yandex.chemodan.app.fotki.dao.configuration.FotkiDataSourceContextConfiguration;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvm2MpfsContextConfiguration;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

@Configuration
@Import({FotkiDataSourceContextConfiguration.class,
        FotkiJettyContextConfiguration.class,
        ZkTvm2MpfsContextConfiguration.class,
        DownloaderHttpClientContextConfiguration.class,
        ProdBlackboxContextConfiguration.class})
public class FotkiContextConfiguration {

    @Bean
    public PhotoProxyManager photoProxyManager(ImageDao imageDao, AlbumDao albumDao, AlbumManager albumManager, MpfsClient mpfsClient,
            HttpClient downloaderHttpClient, Blackbox2 blackbox, @Value("${fotki.save-mpfs-path.threads}") int saveMpfsPathThreadsCount) {
        return new PhotoProxyManager(imageDao, albumDao, albumManager, mpfsClient, downloaderHttpClient, blackbox, saveMpfsPathThreadsCount);
    }

    @Bean
    public AlbumManager albumManager(AlbumDao albumDao) {
        return new AlbumManager(albumDao);
    }

    @Bean
    public BlockPhotoManager blockPhotoManager(ImageDao imageDao) {
        return new BlockPhotoManager(imageDao);
    }
}
