package ru.yandex.chemodan.app.fotki;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.misc.web.servlet.PidServlet;
import ru.yandex.misc.web.servlet.WtdFilter;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
public class FotkiJettyContextConfiguration {

    @Bean
    public ParsePhotoUrlServlet getPhotoServlet(PhotoProxyManager photoProxyManager) {
        return new ParsePhotoUrlServlet(photoProxyManager);
    }

    @Bean
    public AlbumUrlServlet getAlbumServlet(PhotoProxyManager photoProxyManager) {
        return new AlbumUrlServlet(photoProxyManager);
    }

    @Bean
    public PromoUrlServlet getPromoUrlServlet() {
        return new PromoUrlServlet();
    }

    @Bean BlockPhotoUrlServlet blockPhotoUrlServlet(BlockPhotoManager blockPhotoManager) {
        return new BlockPhotoUrlServlet(blockPhotoManager);
    }

    @Bean
    public SingleWarJetty fotkiJetty(
            @Value("${fotki.http.port}") int httpPort,
            @Value("${fotki.http.maxThreads:-1000}") int maxThreads,
            @Value("${fotki.http.maxQueueLength:-1000}") int maxQueueLength,
            ParsePhotoUrlServlet parsePhotoUrlServlet,
            AlbumUrlServlet albumUrlServlet,
            PromoUrlServlet promoUrlServlet,
            CoolPingServlet coolPingServlet,
            BlockPhotoUrlServlet blockPhotoUrlServlet,
            Tvm2Filter tvm2Filter)
    {
        SingleWarJetty jetty = new SingleWarJetty();
        jetty.setHttpPort(httpPort);
        jetty.setMaxThreads(maxThreads);
        jetty.setMaxQueueLength(maxQueueLength);
        jetty.setCopyBeanPostprocessors(true);
        jetty.setLookupServletsInContext(false);
        jetty.addFilterMapping("/*", new WtdFilter());
        jetty.addFilterMapping("/block", tvm2Filter);

        jetty.addServletMapping("/ping", coolPingServlet);
        jetty.addServletMapping("/pid", new PidServlet());
        jetty.addServletMapping("/get/*", parsePhotoUrlServlet);
        jetty.addServletMapping("/next/users/*", albumUrlServlet);
        jetty.addServletMapping("/users/*", albumUrlServlet);
        jetty.addServletMapping("/block", blockPhotoUrlServlet);
        jetty.addServletMapping("/*", promoUrlServlet);

        return jetty;
    }
}
