package ru.yandex.chemodan.app.fotki;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.chemodan.mpfs.UserBlockedException;
import ru.yandex.chemodan.mpfs.UserNotInitializedException;
import ru.yandex.chemodan.util.exception.PermanentHttpFailureException;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class ParsePhotoUrlServlet extends AbstractFotkiServlet {

    private static final Logger logger = LoggerFactory.getLogger(ParsePhotoUrlServlet.class);

    private PhotoProxyManager photoProxyManager;

    public ParsePhotoUrlServlet(PhotoProxyManager photoProxyManager) {
        this.photoProxyManager = photoProxyManager;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            final Image imageParsed = UrlParser.parseUrl(req.getPathInfo());
            final String previewPath = photoProxyManager.getImage(imageParsed);
            resp.setStatus(HttpStatus.SC_204_NO_CONTENT);
            resp.addHeader("X-Accel-Redirect", previewPath);
            resp.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            resp.addHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        } catch (PermanentHttpFailureException ex) {
            logger.error(ex.getMessage());
            resp.setStatus(ex.getStatusCode().get());
        } catch (HttpException ex) {
            logger.error(ex.getMessage());
            resp.setStatus(ex.getStatusCode().get());
        } catch (UserNotInitializedException ex) {
            logger.error(ex.getMessage());
            resp.setStatus(HttpStatus.SC_404_NOT_FOUND);
        } catch (UserBlockedException ex) {
            logger.error(ex.getMessage());
            resp.setStatus(HttpStatus.SC_403_FORBIDDEN);
        }
    }
}
