package ru.yandex.chemodan.app.fotki;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.misc.test.Assert;
import ru.yandex.misc.web.servlet.mock.MockHttpServletRequest;
import ru.yandex.misc.web.servlet.mock.MockHttpServletResponse;

import static org.mockito.ArgumentMatchers.any;
import static ru.yandex.misc.db.embedded.ActivateEmbeddedPg.EMBEDDED_PG;

@RunWith(SpringJUnit4ClassRunner.class)
@ActiveProfiles(EMBEDDED_PG)
public class ParsePhotoUrlServletTest extends FotkiAbstractTest {

    @Autowired
    ParsePhotoUrlServlet parsePhotoUrlServlet;

    @Test
    public void testDoGet() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setPathInfo("/1026686/28500736.431/0_cd05f_1fb89706_orig");
        PhotoProxyManager photoProxyManager = Mockito.mock(PhotoProxyManager.class);
        Mockito.when(photoProxyManager.getImage(any())).thenReturn("");
        MockHttpServletResponse response = new MockHttpServletResponse();
        parsePhotoUrlServlet.doGet(request, response);
        Assert.equals(404, response.getStatus());
    }
}
