package ru.yandex.chemodan.app.fotki;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.fotki.dao.ImageDao;
import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;
import ru.yandex.misc.test.Assert;

import static ru.yandex.misc.db.embedded.ActivateEmbeddedPg.EMBEDDED_PG;

@RunWith(SpringJUnit4ClassRunner.class)
@ActiveProfiles(EMBEDDED_PG)
public class PhotoProxyManagerTest extends FotkiAbstractTest {

    @Autowired
    PhotoProxyManager photoProxyManager;

    @Autowired
    ImageDao imageDao;

    @Autowired
    JdbcTemplate3 jdbcTemplate;

    @Test
    public void testDao() {

        Image image = Image.builder().imageId(839775).dirName("28500736.431").build();
        final Option<Image> found = imageDao.find(image);
        Assert.assertTrue(found.isPresent());
    }

    @Before
    public void setUp() throws Exception {
        String q1 = "INSERT INTO albums(album_id, user_id) values (?, ?)";
        jdbcTemplate.update(q1, 1, 15147017);
        String q2 = "INSERT INTO images(image_id, dir_name, album_id, user_id) values (?, ?, ?, ?)";
        jdbcTemplate.update(q2, 839775, "28500736.431", 1, 15147017);
    }
}
