package ru.yandex.chemodan.app.fotki;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.chemodan.app.fotki.dao.model.ImageSize;

public class UrlParserTest {
    private static final String BASE_TEST_URL = "/17870/159828548.1f/0_STATIC1762a0_e0f6d170_L";

    @Test
    public void testParseValidUrl() {
        assertImageEqualsBaseUrl(UrlParser.parseUrl(BASE_TEST_URL));
    }

    @Test
    public void testParseUrlLenientValid() {
        assertImageEqualsBaseUrl(UrlParser.parseUrlLenient(BASE_TEST_URL));
        assertImageEqualsBaseUrl(UrlParser.parseUrlLenient("get" + BASE_TEST_URL));
        assertImageEqualsBaseUrl(UrlParser.parseUrlLenient("/get" + BASE_TEST_URL));
        assertImageEqualsBaseUrl(UrlParser.parseUrlLenient("https://img-fotki.yandex.ru/get" + BASE_TEST_URL));
    }

    private void assertImageEqualsBaseUrl(Image image) {
        Assert.assertEquals(1532576, image.getImageId());
        Assert.assertEquals("159828548.1f", image.getDirName());
        Assert.assertEquals(ImageSize.L, image.getSize());
        Assert.assertEquals(0, image.getVersion());
    }
}
