package ru.yandex.chemodan.app.fotki.dao;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.fotki.dao.model.Album;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * Методы, возвращающие список альбомов или считающие количество, в основном работают только с
 * альбомами, у которых state == AVAILABLE. Исключение составляют методы с AllState и AnyState в
 * названии. Такие методы не смотрят на state.
 *
 * @author Ildar Safarov
 */
public class AlbumDaoImpl implements AlbumDao {

    private final JdbcTemplate3 jdbcTemplate;

    public AlbumDaoImpl(JdbcTemplate3 jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public Option<Album> findAlbumById(PassportUid uid, int albumId) {
        String q = "SELECT album_id, user_id, parent_id, title, state, description FROM albums WHERE album_id = ? AND user_id = ?";
        return jdbcTemplate.queryForOption(q, AlbumMapper.INSTANCE, albumId, uid);
    }
}
