package ru.yandex.chemodan.app.fotki.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.chemodan.app.fotki.dao.model.Album;
import ru.yandex.chemodan.app.fotki.dao.model.AlbumState;
import ru.yandex.inside.passport.PassportUid;

public final class AlbumMapper implements RowMapper<Album> {

    public static final AlbumMapper INSTANCE = new AlbumMapper();

    private AlbumMapper() {
    }

    @Override
    public Album mapRow(ResultSet rs, int rn) throws SQLException {
        return Album.builder()
                .albumId(rs.getInt("album_id"))
                .authorId(PassportUid.cons(rs.getLong("user_id")))
                .parentId(rs.getInt("parent_id"))
                .title(rs.getString("title"))
                .state(AlbumState.R.fromValue(rs.getInt("state")))
                .description(rs.getString("description"))
                .build();
    }
}
