package ru.yandex.chemodan.app.fotki.dao;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public class ImageDaoImpl implements ImageDao {

    private final JdbcTemplate3 jdbcTemplate;

    public ImageDaoImpl(JdbcTemplate3 jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public Option<Image> find(Image image) {
        String q = "SELECT image_id, album_id, user_id, orig_image_format, filename, title, flags, ph_storage_id, "
                + "dir_name, rnd, version, mpfs_path_found, mpfs_path FROM images WHERE image_id = ? and dir_name = ?";
        return jdbcTemplate.queryForOption(q, ImageMapper.INSTANCE, image.getImageId(), image.getDirName());
    }

    @Override
    public int saveMpfsPath(boolean mpfsPathFound, String mpfsPath, int imageId, String dirName) {
        String q = "UPDATE images SET mpfs_path_found = ?, mpfs_path = ? WHERE image_id = ? and dir_name = ?";
        return jdbcTemplate.update(q, mpfsPathFound, mpfsPath, imageId, dirName);
    }

    @Override
    public int updateFlags(Image image, long maskToSet, long maskToClear) {
        String q = "UPDATE images SET flags = (flags | ?) & ~ ? WHERE image_id = ? and dir_name = ?";
        return jdbcTemplate.update(q, maskToSet, maskToClear, image.getImageId(), image.getDirName());
    }

    @Override
    public int[] batchUpdateFlags(ListF<Image> batch, long maskToSet, long maskToClear) {
        final ListF<Object[]> args = batch.map(i -> new Object[]{maskToSet, maskToClear, i.getImageId(), i.getDirName()});
        String q = "UPDATE images SET flags = (flags | ?) & ~ ? WHERE image_id = ? and dir_name = ?";
        return jdbcTemplate.batchUpdate(q, args);
    }

    @Override
    public Option<Image> find(PassportUid userId, int imageId) {
        String q = "SELECT image_id, album_id, user_id, orig_image_format, filename, title, flags, ph_storage_id, "
                + "dir_name, rnd, version, mpfs_path_found, mpfs_path FROM images WHERE user_id = ? and image_id = ?";
        return jdbcTemplate.queryForOption(q, ImageMapper.INSTANCE, userId, imageId);
    }
}
