package ru.yandex.chemodan.app.fotki.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.chemodan.app.fotki.dao.model.ImageFlagSet;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.inside.passport.PassportUid;

public class ImageMapper implements RowMapper<Image> {

    public static final ImageMapper INSTANCE = new ImageMapper();

    private ImageMapper() {
    }

    @Override
    public Image mapRow(ResultSet rs, int rowNum) throws SQLException {
        return Image.builder()
                .imageId(rs.getInt("image_id"))
                .albumId(rs.getInt("album_id"))
                .authorId(PassportUid.cons((rs.getLong("user_id"))))
                .originalImageFormat(ImageFormat.R.fromValue(rs.getInt("orig_image_format")))
                .fileName(rs.getString("filename"))
                .title(rs.getString("title"))
                .flags(new ImageFlagSet(rs.getLong("flags")))
                .phStorageId(rs.getInt("ph_storage_id"))
                .dirName(rs.getString("dir_name"))
                .rnd(rs.getInt("rnd"))
                .version(rs.getInt("version"))
                .mpfsPathFound(rs.getBoolean("mpfs_path_found"))
                .mpfsPath((rs.getString("mpfs_path")))
                .build();
    }
}
