package ru.yandex.chemodan.app.fotki.dao.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.misc.db.embedded.ConditionalOnMissingEmbeddedDb;

@Configuration
@Import(FotkiJdbcContextConfiguration.class)
@ConditionalOnMissingEmbeddedDb
public class FotkiDataSourceContextConfiguration {

    @Bean
    @OverridableValuePrefix("fotki")
    public DataSourceProperties fotkiDataSourceProperties() {
        return new DataSourceProperties();
    }
}
