package ru.yandex.chemodan.app.fotki.dao.configuration;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.fotki.dao.AlbumDao;
import ru.yandex.chemodan.app.fotki.dao.AlbumDaoImpl;
import ru.yandex.chemodan.app.fotki.dao.ImageDao;
import ru.yandex.chemodan.app.fotki.dao.ImageDaoImpl;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@Configuration
@Import(JdbcDatabaseConfiguratorContextConfiguration.class)
public class FotkiJdbcContextConfiguration {
    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;


    @Bean
    public JdbcDatabaseConfigurator fotkiDbConfigurator(DataSourceProperties fotkiDataSourceProperties) {
        return dbConfiguratorConfig.consJdbcConfigurator(fotkiDataSourceProperties);
    }

    @Bean
    public DataSource fotkiDataSource(JdbcDatabaseConfigurator fotkiDbConfigurator) {
        return fotkiDbConfigurator.configureDataSource();
    }

    @Bean
    public JdbcTemplate3 fotkiJdbcTemplate(
            JdbcDatabaseConfigurator fotkiDbConfigurator, DataSource fotkiDataSource)
    {
        return fotkiDbConfigurator.consTemplate(fotkiDataSource);
    }

    @Bean
    public ImageDao imageDao(JdbcTemplate3 fotkiJdbcTemplate) {
        return new ImageDaoImpl(fotkiJdbcTemplate);
    }

    @Bean
    public AlbumDao albumDao(JdbcTemplate3 fotkiJdbcTemplate) {
        return new AlbumDaoImpl(fotkiJdbcTemplate);
    }
}
