package ru.yandex.chemodan.app.fotki.dao.model;

import ru.yandex.chemodan.app.fotki.utils.FlagUtils;
import ru.yandex.misc.enums.flag.Flag;

/**
 * Our fotki bicycle to work with flags.
 * We don't use FlagSet/FlagSet2 because of different workflow with flags. We don't need additional information
 * about set/unset flags -- only a current state. Often we do full flags update, not only changed (so we need
 * an actual flags state always).
 *
 * This class is designed to be immutable. So don't hack it! :)
 *
 * @author Dmitriy Komanov (spacelord)
 */
public abstract class FlagSupport<T extends Enum<T> & Flag, V extends FlagSupport> {
    private final long mask;

    protected FlagSupport(long mask) {
        ru.yandex.misc.enums.flag.FlagUtils.isValidBitMask(mask);

        this.mask = mask;
    }

    public final boolean isSet(T flag) {
        return FlagUtils.isFlagSet(this.mask, flag);
    }

    public final V unset(T flag) {
        return create(this.mask & ~flag.mask());
    }

    protected abstract V create(long mask);

    @Override
    public int hashCode() {
        return Long.valueOf(mask).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || (obj != null && obj.getClass() == getClass() && mask == ((FlagSupport) obj).mask);
    }

    @Override
    public String toString() {
        return mask + "(" + Long.toBinaryString(mask) + ")";
    }
}
