package ru.yandex.chemodan.app.fotki.dao.model;

import lombok.Builder;
import lombok.Data;

import ru.yandex.commune.image.ImageFormat;
import ru.yandex.inside.passport.PassportUid;

@Builder(toBuilder = true)
@Data
public class Image {

    private int imageId;
    private int albumId;
    private PassportUid authorId;
    private String login;
    /**
     * We do store an image format only for original. Mostly, image format is necessary for some statistics and
     * for social sharing (twitter etc.) - we need to place file extension (for understanding by clients that
     * it's an image).
     *
     * The {@link ImageFormat#UNKNOWN} is a valid value for an image format. It could be unknown in two cases:
     * <ul>
     *     <li>Image was not migrated</li>
     *     <li>Image was not completed ({@link ImageFlag#INCOMPLETE}).</li>
     * </ul>
     * */
    private ImageFormat originalImageFormat;
    private String fileName ;
    private String title;
    private ImageFlagSet flags;
    private int phStorageId;
    private String dirName;
    private int rnd;
    private int version;
    private ImageSize size;
    private boolean mpfsPathFound;
    private String mpfsPath;

    public String getExtension() {
        return (originalImageFormat != ImageFormat.UNKNOWN ? originalImageFormat : ImageFormat.JPEG).getExtension();
    }
}
