package ru.yandex.chemodan.app.fotki.dao.model;

import ru.yandex.bolts.collection.Option;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public enum ImageFileType {
    ORIG("orig"), EDORIG("edorig"), PREVIEW("thumb");

    private final String name;

    ImageFileType(String name) {
        this.name = name;
    }

    public Option<String> getSuffixO() {
        return Option.when(this != ORIG, "_" + name);
    }

    @Override
    public String toString() {
        return name;
    }
}
