package ru.yandex.chemodan.app.fotki.dao.model;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.enums.flag.Flag;
import ru.yandex.misc.enums.flag.FlagResolver;

/**
 * @author Ilya Rubin
 * @author Stepan Koltsov
 * @author Ildar Safarov
 * @author Dmitriy Komanov (spacelord)
 */
public enum ImageFlag implements Flag {

    /**
     * There are at least one record in contest_binding_% table.
     */
    IN_USER_CONTEST(      0x00000001),

    GEO_IRRELEVANT(       0x00000002),
    PORNO(                0x00000004),
    FOR_MORDA(            0x00000008),
    BLOCKED(              0x00000010),

    /**
     * Exif repair is needed PHOTO-11722
     */
    EXIF_LOST_IN_STORAGE(   0x00000020),

    /**
     * There is EXIF on storage AND there are visible tags fpr {@link ru.yandex.fotki.web.action.image.GetExifAction}
     *
     * @see ru.yandex.fotki.util.exif.ExifTagLibrary#VISIBLE_TAGS
     */
    HAS_VISIBLE_EXIF_DATA(0x00000040),

    /**
     * {@link ru.yandex.fotki.loader.AddImageManager#addNewImage(ru.yandex.inside.passport.PassportUid, String, MediaType, String)} was called
     * but {@link ru.yandex.fotki.loader.AddImageManager#finalize(ImageRef, ru.yandex.fotki.outside.engine.ImageStorageAddress, ru.yandex.fotki.loader.UploadFinalizationParameters)}
     * wasn't or rollback during upload was launched.
     *
     * XXX We should stop using this flag and use ConvertState instead, see PHOTO-10115
     */
    INCOMPLETE(           0x00000080),

    COMMENTED(            0x00000100),
    TAG_OF_THE_DAY(       0x00000200),

    /**
     * Image is a preview thumbnail for album.
     */
    THUMBNAIL(            0x00000400),

    COMMENTS_DISABLED(    0x00000800),
    MODERATED(            0x00001000),
    PHOTO_OF_DAY_MEDAL(   0x00002000),
    TOP10_MEDAL(          0x00004000),
    LOST_IN_STORAGE(      0x00008000),
    X_UNUSED2(            0x00010000),
    X_UNUSED3(            0x00020000),
    HAS_BAD_TAGS(         0x00040000),
    TMP_LINKED(           0x00080000), // new-style privacy applied
    HIDE_ORIGINAL(        0x00100000),

    /**
     * There are {@link ru.yandex.fotki.core.image.size.ImageSize#EDITED_ORIG} on a storage.
     */
    HAS_EDITED_ORIGINAL(  0x00200000),

    GEOBOUND(             0x00400000),
    NON_JPEG(             0x00800000),
    DISABLE_VOTES(        0x01000000), // TODO: usages will be removed after PHOTO-11943 and nextVerstka goes to prod
    HAS_DESCRIPTION(      0x02000000),
    MOBILE_UPLOADED(      0x04000000),
    // HAS_AREAS and HAS_TAGS are sticky flags. we set them if areas or tags are added to image), but do not care to reset
    HAS_AREAS(            0x08000000),
    HAS_TAGS(             0x10000000),
    NO_MORE_PARTICIPATION(0x20000000),
    COPYRIGHTED(          0x40000000),
    ADDRESS_BOUND(       0x80000000L),

    HAS_LARGE_THUMBS(   0x100000000L),

    /**
     * This flag indicates that the image sizes will be calculated in code, instead of querying them from database.
     */
    CALCULATED_SIZE(    0x200000000L),
    ADDRESS_REJECTED(   0x400000000L), // PHOTO-7465
    X_UNUSED_4( 0x800000000L), // former ADDRESS_IRRELEVANT
    /** see comments in ImageManager.addStorageStaticAccess() */
    HAS_STORAGE_STATIC_ACCESS(0x1000000000L),
    /**
     * see ImageSize.MORDA_THUMBNAILS
     */
    HAS_MORDA_THUMBNAILS(0x2000000000L),

    /**
     * Should be used only if {@link ImageFlag#HAS_EDITED_ORIGINAL} is set. Used in image printing to determine
     * whether online converting/rotating should be performed with image.
     *
     * Old images that have EDITED_ORIG (elder that March of 2013) in JPEG always (jpeg by exif rotated, non-JPEGs
     * etc.). New edited images will be in source format.
     *
     * @see ru.yandex.fotki.loader.ImageProcessingManager
     */
    EDITED_ORIGINAL_NOT_JPEG(0x4000000000L),

    /**
     * There is a file on storage with EXIF parsed data.
     */
    HAS_EXIF_ON_STORAGE(0x8000000000L),

    /**
     * Deprecated in prior to {@link ImageFlag#HAS_STILL_GIF}. Indicates, that image is deanimated with an
     * old way. Should be converted to new way and removed flag.
     */
    HAS_STILL_GIF_LEGACY(0x10000000000L),

    /**
     * This is a great hack for deanimated GIF images. We store deanimated images on storage:
     * Usual file: {@code 28532222.17/0_96fad_738df5f8_XL}
     * Still file: {@code 28532222.17/0_96fad_738df5f8_GIFXL}
     *
     * As you see, there are "GIF" prefix, this prefix could be parsed with
     * {@link ru.yandex.fotki.core.image.StorageFileName#parseO(String)}
     * method, so it can be used transparently for proxy, logdaemon and other places. But we need to delete this
     * images depends on this flag (like {@link #HAS_STORAGE_STATIC_ACCESS}, but lesser url hacking - it's harder to
     * introduce new prefix like "STATIC" in link because it should be present in all regex).
     *
     * @see ru.yandex.fotki.core.image.StorageFileName#STILL_GIF_PREFIX
     *
     * @url https://jira.yandex-team.ru/browse/PHOTO-10380
     */
    HAS_STILL_GIF(0x20000000000L),
    /**
     * Has 2nd generation large thumbnails.
     * @url https://jira.yandex-team.ru/browse/PHOTO-11376
     */
    HAS_X_LARGE_THUMBS(0x40000000000L),

    /**
     * @see <a href="https://st.yandex-team.ru/PHOTO-12648">PHOTO-12648</a>
     */
    EDITOR_CHOICE(0x80000000000L),

    MIGRATED_TO_DISK(0x100000000000L),

    YA_DISK_SKIP(0x200000000000L),

    YA_DISK_OMIT_COMMENTS(0x400000000000L),

    YA_DISK_MARK(0x800000000000L),

    YA_DISK_PREVIEW_MIGRATED(0x1000000000000L),

    YA_DISK_FORCED_EDORIG(0x2000000000000L),

    YA_DISK_BROKEN_OR_MISSING(0x4000000000000L)
    ;

    private final long mask;
    private final int position;

    private ImageFlag(long mask) {
        this.mask = mask;
        this.position = ru.yandex.misc.enums.flag.FlagUtils.getPositionByMask(mask);
    }

    @Override
    public long mask() {
        return mask;
    }

    @Override
    public int position() {
        return position;
    }

    public static Function<ImageFlag, Long> maskF() {
        return new Function<ImageFlag, Long>() {
            public Long apply(ImageFlag imageFlag) {
                return imageFlag.mask;
            }
        };
    }

    public static final int UPDATE_NO_FLAGS = 0;

    public static final FlagResolver<ImageFlag> R = FlagResolver.r(ImageFlag.class);
}
