package ru.yandex.chemodan.app.fotki.dao.model;

import java.util.EnumSet;

import javax.annotation.Nullable;

import ru.yandex.misc.enums.IntEnum;

/**
 * Enumeration encapsulates different image sizes parameters
 *
 * Value used in a database (table image_sizes). Negative value means that such value should not
 * be stored.
 *
 * @author alexm
 * @author Ildar Safarov
 * @author Dmitriy Komanov (spacelord)
 */
public enum ImageSize implements IntEnum {
    ORIG(1, -1, -1, "orig"),
    XXXL(2, 1280, 1280, "XXXL"),
    XXL(3, 1024, 1024, "XXL"),
    XL(4, 800, 800, "XL"),
    L(5, 500, 500, "L"),
    M(6, 300, 300, "M"),
    S(7, 150, 150, "S"),
    XS(8, 100, 100, "XS"),
    XXS(9, 75, 75, "XXS"),
    XXXS(10, 50, 50, "XXXS"),
    X4L(11, 1600, 1600, "X4L"),
    X5L(12, 2560, 2560, "X5L"),
    EDORIG(13, -1, -1, "edorig");

    private static final EnumSet<ImageSize> ORIGINAL = EnumSet.of(ORIG, EDORIG);

    private final int width;
    private final int height;
    private final String name;
    private final int value;

    ImageSize(int value, int width, int height, String name) {
        this.value = value;
        this.width = width;
        this.height = height;
        this.name = name;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public String getName() {
        return name;
    }

    @Override
    public int value() {
        return value;
    }

    public static boolean isOriginal(@Nullable ImageSize imageSize) {
        return imageSize == null || ORIGINAL.contains(imageSize); //null will be treated as original
    }
}
