package ru.yandex.chemodan.app.fotki.utils;

import org.apache.commons.text.StringEscapeUtils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.fotki.dao.model.Album;
import ru.yandex.chemodan.app.fotki.dao.model.Image;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class NameUtils {
    private static final int MAX_DIR_NAME_LEN = 100;

    private static final SetF<String> IMAGE_EXTENSIONS = Cf.set(
            "ase", "art", "bmp", "blp", "cd5", "cit", "cpt", "cr2", "cut", "dds", "dib", "djvu", "egt", "exif", "gif",
            "gpl", "grf", "icns", "ico", "iff", "jng", "jpeg", "jpg", "jfif", "jp2", "jps", "lbm", "max", "miff", "mng",
            "msp", "nitf", "ota", "pbm", "pc1", "pc2", "pc3", "pcf", "pcx", "pdn", "pgm", "pi1", "pi2", "pi3", "pict",
            "pct", "pnm", "pns", "ppm", "psb", "psd", "pdd", "psp", "px", "pxm", "pxr", "qfx", "raw", "rle", "sct",
            "sgi", "rgb", "int", "bw", "tga", "tiff", "tif", "vtf", "xbm", "xcf", "xpm", "3dv", "amf", "ai", "awg",
            "cgm", "cdr", "cmx", "dxf", "e2d", "egt", "eps", "fs", "gbr", "odg", "svg", "stl", "vrml", "x3d", "sxd",
            "v2d", "vnd", "wmf", "emf", "art", "xar", "png", "webp", "jxr", "hdp", "wdp", "cur", "ecw", "iff", "lbm",
            "liff", "nrrd", "pam", "pcx", "pgf", "sgi", "rgb", "rgba", "bw", "int", "inta", "sid", "ras", "sun", "tga"
    );

    private static final SetF<String> SPECIAL_MPFS_NAMES = Cf.set(".", "..");

    public static String extractDirName(Album album) {
        String title = unescape(album.getTitle());
        return StringUtils.substring(sanitize(title),0, MAX_DIR_NAME_LEN);
    }

    public static String extractFilename(Image image) {
        return sanitize(extractFilenameRaw(image));
    }

    private static String extractFilenameRaw(Image image) {
        if (StringUtils.isNotBlank(image.getFileName())) {
            return removeExtension(unescape(image.getFileName()));
        } else if (StringUtils.isNotBlank(image.getTitle())) {
            return unescape(image.getTitle());
        } else {
            return String.valueOf(image.getImageId());
        }
    }

    public static String removeExtension(String filename) {
        return extractImageExtension(filename)
                .map(ext -> filename.substring(0, filename.length() - ext.length() - 1))
                .getOrElse(filename);
    }

    private static Option<String> extractImageExtension(String filename) {
        int dotPosition = filename.lastIndexOf('.');
        if (dotPosition == -1) {
            return Option.empty();
        }

        String ext = filename.substring(dotPosition + 1).toLowerCase();
        if (IMAGE_EXTENSIONS.containsTs(ext)) {
            return Option.of(ext);
        }

        return Option.empty();
    }

    private static String unescape(String string) {
        return StringEscapeUtils.unescapeXml(string);
    }

    private static String sanitize(String string) {
        if (SPECIAL_MPFS_NAMES.containsTs(string)) {
            return string + " ";
        }
        return string.replaceAll("/", " ");
    }
}
