package ru.yandex.chemodan.app.fotki.utils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.IterableF;
import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class Path extends DefaultObject implements IterableF<Path> {
    private final ListF<String> chunks;

    private final boolean absolute;

    Path(ListF<String> chunks, boolean absolute) {
        this.chunks = chunks;
        this.absolute = absolute;
    }

    public static Path get(String... paths) {
        return get(Cf.list(paths));
    }

    public static Path get(ListF<String> paths) {
        return paths.map(Path::get)
                .reduceLeft(Path::resolve);
    }

    private static Path get(String path) {
        path = StringUtils.strip(path);
        return new Path(split(path), path.startsWith("/"));
    }

    public Path resolve(String path) {
        return new Path(chunks.plus(split(path)), absolute);
    }

    public Path resolve(Path path) {
        return new Path(chunks.plus(path.chunks), absolute);
    }

    @Override
    public IteratorF<Path> iterator() {
        return chunks.iterator()
                .map(s -> new Path(Cf.list(s), false));
    }

    @Override
    public String toString() {
        return (absolute ? "/" : "") + StringUtils.join(chunks, "/");
    }

    private static ListF<String> split(String path) {
        return Cf.list(path.split("/"))
                .filter(StringUtils::isNotBlank);
    }
}
