package ru.yandex.chemodan.app.grelka;

import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.dataSize.DataSize;

public class GrelkaConfig {

    private final DynamicProperty<Long> availabilityCheckInterval = new DynamicProperty<>("grelka-availability-check-interval", 1000L);
    private final DynamicProperty<Long> availabilityCheckTimeout = new DynamicProperty<>("grelka-availability-check-timeout", 10L);
    private final DynamicProperty<ListF<String>> exts = new DynamicProperty<>("grelka-extensions-with-sizes",
            Cf.list("pptx","ppt","djvu","djv"));
    private final DynamicProperty<String> size = new DynamicProperty<>("grelka-default-size", "100b", v -> {
        try {
            return DataSize.valueOf(v) != null;
        } catch (Exception e) {
            return false;
        }
    });

    public Option<DataSize> getSize(String ext) {
        Map<String, DataSize> sizeConfigs = getSizeConfigs();
        return Option.ofNullable(sizeConfigs.get(ext.toLowerCase()));
    }

    Map<String, DataSize> getSizeConfigs() {
        return buildConfig(exts.get(), DataSize.valueOf(size.get()));
    }

    Map<String, DataSize> buildConfig(ListF<String> strings, DataSize defaultSize) {
        return strings.stream().map(s -> s.toLowerCase().split(":"))
                .collect(Collectors.toMap(e -> e[0], e -> e.length == 1 ? defaultSize : DataSize.valueOf(e[1])));
    }

    public long getAvailabilityCheckInterval() {
        return availabilityCheckInterval.get();
    }

    public long getAvailabilityCheckTimeout() {
        return availabilityCheckTimeout.get();
    }

}
