package ru.yandex.chemodan.app.grelka;

import java.util.Map;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.dataSize.DataSize;

public class GrelkaConfigTest {

    @Test
    public void buildConfig() {
        GrelkaConfig config = new GrelkaConfig();
        Map<String, DataSize> extDataSizeMap = config.buildConfig(Cf.list("pptx:1kb","ppt:0","djvu:","djv:10mb"),
                DataSize.valueOf("100b"));
        Assert.assertNotNull(extDataSizeMap);
        Assert.assertEquals(extDataSizeMap.get("pptx"), DataSize.fromKiloBytes(1));
        Assert.assertEquals(extDataSizeMap.get("ppt"), DataSize.ZERO);
        Assert.assertEquals(extDataSizeMap.get("djvu"), DataSize.fromBytes(100));
        Assert.assertEquals(extDataSizeMap.get("djv"), DataSize.fromMegaBytes(10));
        Assert.assertNull(extDataSizeMap.get("abc"));

    }
}
