package ru.yandex.chemodan.app.grelka;

import java.util.concurrent.ThreadPoolExecutor;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.admin.ChemodanAdminDaemonContextConfiguration;
import ru.yandex.chemodan.logbroker.DiskLbConsumerContextConfiguration;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsClientContextConfiguration;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.chemodan.uploader.docviewer.DocviewerContextConfiguration;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistry;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistryContextConfiguration;
import ru.yandex.commune.dynproperties.DynamicPropertiesContextConfiguration;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;
import ru.yandex.inside.logbroker.pull.consumer.LbSimpleAsyncLineListener;

/**
 * @author swined
 */
@Configuration
@Import({
        DiskLbConsumerContextConfiguration.class,
        DocviewerContextConfiguration.class,
        MpfsClientContextConfiguration.class,
        DynamicPropertiesContextConfiguration.class,
        ZkAdminContextConfiguration.class,
        ChemodanCommonContextConfiguration.class,
        ChemodanAdminDaemonContextConfiguration.class,
        YandexStaffUserRegistryContextConfiguration.class
})
public class GrelkaContextConfiguration {

    @Bean
    public LogListener grelkaEventLogListener(DocviewerClient docviewerClient, MpfsClient mpfsClient,
            GrelkaConfig config, YandexStaffUserRegistry staffUserRegistry)
    {
        return new GrelkaEventLogListener(docviewerClient, mpfsClient, config, staffUserRegistry);
    }

    @Bean
    public GrelkaConfig grelkaConfig() {
        return new GrelkaConfig();
    }

    @Bean
    public LbSimpleAsyncLineListener lbConsumerListener(
            LogListener listener,
            @Qualifier("lbListenerExecutor") ThreadPoolExecutor listenerExecutor)
    {
        return new LbSimpleAsyncLineListener(listener, listenerExecutor);
    }


}
