package ru.yandex.chemodan.app.hackathon;

import lombok.Data;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class DivTemplateProcessorTest {

    @Test
    public void processTemplate() {
        DivTemplateProcessor processor = new DivTemplateProcessor("test_template.ftj");
        String link = "https://3.downloader.disk.yandex.ru/preview/2c50e732b5a372220bc40c9e0fdb5ebcea878b3872f850eb013be6936d9cc48c/inf/cm4vqLPe-BBxq_712m951lbSm7_qn1wL2znqvR0siGPAxSBVJdeKqJQSEiLZ0hErw87iMFpEgmssvCChP1C4Mg==?uid=50273844&filename=2019-09-19+20-48-52.JPG&disposition=inline&hash=&limit=0&content_type=image%2Fjpeg&tknv=v2&owner_uid=50273844&size=248x188&crop=1";
        ListF<BlockModel> blocks = Cf.list(new BlockModel(link));

        Assert.equals("I am a template!\n" +
                "\n" +
                "    <h1>https://3.downloader.disk.yandex.ru/preview/2c50e732b5a372220bc40c9e0fdb5ebcea878b3872f850eb013be6936d9cc48c/inf/cm4vqLPe-BBxq_712m951lbSm7_qn1wL2znqvR0siGPAxSBVJdeKqJQSEiLZ0hErw87iMFpEgmssvCChP1C4Mg==?uid=50273844&amp;filename=2019-09-19+20-48-52.JPG&amp;disposition=inline&amp;hash=&amp;limit=0&amp;content_type=image%2Fjpeg&amp;tknv=v2&amp;owner_uid=50273844&amp;size=248x188&amp;crop=1</h1>\n" +
                "    <h1>b</h1>\n" +
                "    <h1>lev</h1>\n", processor.processTemplate(Cf.map("blocks", blocks)));
    }

    @Test
    public void words() {
        String requestText = "подборка";

        System.out.println(requestText.replaceAll("[,!?]", " "));
        requestText = requestText.replaceAll("[,!?]", " ");
        ListF<String> words = Cf.x(requestText.split(" "))
                .filter(StringUtils::isNotBlank)
                .map(s -> s.toLowerCase().trim());

        System.out.println(words);
    }

    @Data
    public static class BlockModel {
        public final String imageUrl;
    }
}

