package ru.yandex.chemodan.app.hackathon;

import lombok.Data;
import org.joda.time.DateTime;

import ru.yandex.alice.megamind.protos.scenarios.RequestProto;
import ru.yandex.alice.megamind.protos.scenarios.ResponseProto;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager;
import ru.yandex.chemodan.app.lentaloader.cool.model.MinimalCoolLentaBlock;
import ru.yandex.chemodan.app.lentaloader.cool.utils.BlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.utils.GenerationInterval;
import ru.yandex.chemodan.app.lentaloader.cool.utils.IntervalType;
import ru.yandex.chemodan.app.lentaloader.cool.utils.TitleGenerationContext;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.chemodan.mpfs.MpfsUser;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author tolmalev
 */
public class GetPhotoSelectionsScenario implements AliceScenario {
    private static final Logger logger = LoggerFactory.getLogger(GetPhotoSelectionsScenario.class);

    private final CoolLentaManager coolLentaManager;
    private final MpfsClient mpfsClient;
    private final BlockTitlesGenerator blockTitlesGenerator;

    private final DivTemplateProcessor templateProcessor = new DivTemplateProcessor("list_photo_selections.ftj");

    public GetPhotoSelectionsScenario(CoolLentaManager coolLentaManager, MpfsClient mpfsClient, BlockTitlesGenerator blockTitlesGenerator) {
        this.coolLentaManager = coolLentaManager;
        this.mpfsClient = mpfsClient;
        this.blockTitlesGenerator = blockTitlesGenerator;
    }

    @Override
    public int match(ListF<String> text) {
        return text.exists(s -> s.startsWith("подборк")) ? 200 : 0;
    }

    @Override
    public ResponseProto.TScenarioRunResponse run(long uidL, HttpServletRequestX reqX, ListF<String> words, RequestProto.TScenarioRunRequest request) {
        PassportUid uid = PassportUid.cons(uidL);

        ListF<MinimalCoolLentaBlock> blocks = coolLentaManager.getRandomBlocks(uid, 5);

        ListF<BlockModel> blockModels = blocks.zipWithIndex().map((block, index) -> {
            TitleGenerationContext context = titleGenerationContextForBlock(block);

            String title_1 = blockTitlesGenerator.generateBlockTitle(context).get(Language.RUSSIAN);
            String title_2 = blockTitlesGenerator.generateBlockSubtitle(context).get(Language.RUSSIAN);

            MpfsFileInfo info = mpfsClient.getFileInfoByFileId(MpfsUser.of(uid), block.bestResourceId.fileId);
            String pmid = info.getMeta().getPmid().get();
            String imageUrl = mpfsClient.generateZaberunUrl(pmid, info.name.get(), "preview", Option.of(uid + ""), Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.of("L"), Option.empty(), Option.empty(), Option.of(2000000000), Option.of(0), Option.of(true), Option.empty());

            return new BlockModel(imageUrl, title_1, title_2, index);
        });

        String divJson = templateProcessor.processTemplate(Cf.map("blocks", blockModels));
        logger.info("div json: {}", divJson);

        return ResponseProto.TScenarioRunResponse
                .newBuilder()
                .setResponseBody(ResponseProto.TScenarioResponseBody
                        .newBuilder()
                        .setLayout(ResponseProto.TLayout
                                .newBuilder()
                                .addCards(ResponseProto.TLayout.TCard
                                        .newBuilder()
//                                         .setDivCard(divJson) see: MEGAMIND-378
                                )
                        ))
                .build();
    }

    @Data
    public static class BlockModel {
        public final String imageUrl;
        public final String title;
        public final String subtitle;
        public final int index;
    }

    private TitleGenerationContext titleGenerationContextForBlock(MinimalCoolLentaBlock block) {
        Random2 R = new Random2(block.getBestResourceId().hashCode());

        GenerationInterval interval = block.getGenerationInterval();

        IntervalType intervalType = interval.type;
        DateTime intervalStart = interval.start;

        return new TitleGenerationContext(R, intervalType, intervalStart);
    }
}
