package ru.yandex.chemodan.app.hackathon;

import java.util.List;

import javax.servlet.http.HttpServlet;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.DataApiCoreContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaCoreContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager;
import ru.yandex.chemodan.app.lentaloader.cool.utils.BlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.reminder.Cvi2tProcessor;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClient;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchClientContextConfiguration;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.http.DiskJetty;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsClientContextConfiguration;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.impl.YtUtils;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        A3JettyContextConfiguration.class,
        CoolLentaCoreContextConfiguration.class,
        MpfsClientContextConfiguration.class,
        DiskSearchClientContextConfiguration.class,
        ProdBlackboxContextConfiguration.class,
        DataApiCoreContextConfiguration.class
})
public class HackathonContextConfiguration {

    @Bean
    public HttpServlet aliceServlet(DiskJetty a3Jetty, Tvm2 tvm2, List<AliceScenario> scenarios) {
        AliceScenarioServlet servlet = new AliceScenarioServlet(scenarios, tvm2);
        a3Jetty.addServletMapping("/api", servlet);
        a3Jetty.addServletMapping("/api/*", servlet);
        return servlet;
    }

    @Bean
    public NoResponseScenario noResponseScenario() {
        return new NoResponseScenario();
    }

    @Bean
    public GetPhotoSelectionsScenario getPhotoSelectionsScenario(CoolLentaManager coolLentaManager, MpfsClient mpfsClient,
                                                                 BlockTitlesGenerator blockTitlesGenerator)
    {
        return new GetPhotoSelectionsScenario(coolLentaManager, mpfsClient, blockTitlesGenerator);
    }

    @Bean
    public WhatsOnPhotoScenario whatsOnPhotoScenario() {
        return new WhatsOnPhotoScenario();
    }

    @Bean
    public DemotivationScenario demotivationScenario() {
        return new DemotivationScenario();
    }

    @Bean
    public TestOnePhotoScenario testOnePhotoScenario() {
        return new TestOnePhotoScenario();
    }

    @Bean
    public TestTwoPhotoScenario testTwoPhotoScenario() {
        return new TestTwoPhotoScenario();
    }

    @Bean
    public PhotoStatisticsScenario photoStatisticsScenario() {
        return new PhotoStatisticsScenario();
    }

    @Bean
    public WhatSongScenario whatSongScenario() {
        return new WhatSongScenario();
    }

    @Bean
    public Cvi2tProcessor cvi2tProcessor(DiskSearchClient client) {
        return new Cvi2tProcessor(client, Cf.list());
    }

    @Bean
    public UserTimezoneHelper userTimezoneHelper(Blackbox2 blackbox2) {
        return new UserTimezoneHelper(blackbox2);
    }

    @Bean
    public SearchCache searchCache(DiskSearchClient diskSearchClient) {
        return new SearchCache(ytClient(), diskSearchClient);
    }

    @Bean
    public AboutScenario aboutScenario() {
        return new AboutScenario();
    }

    @Bean
    public HackatonMpfsClient hackatonMpfsClient() {
        return new HackatonMpfsClient();
    }

    @Value("${yt.http.proxy}")
    private String ytHttpProxyUrl;

    @Value("${java-stat.user.yt.token}")
    private String ytUserOauthToken;

    @Bean
    public Yt ytClient() {
        return YtUtils.http(ytHttpProxyUrl, ytUserOauthToken);
    }
}
