package ru.yandex.chemodan.app.hackathon;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchFileInfo;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsFileInfo;
import ru.yandex.chemodan.mpfs.MpfsUser;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author yashunsky
 */
public class HackatonMpfsClient {
    private static final Logger logger = LoggerFactory.getLogger(HackatonMpfsClient.class);
    @Autowired
    private MpfsClient mpfsClient;

    public ListF<String> getPreviews(long uid, ListF<DiskSearchFileInfo> infos) {
        ListF<String> resourceIds = infos.map(info -> uid + ":" + info.getId());
        return getPreviewsByResourceIds(uid, resourceIds);
    }

    public ListF<String> getPreviewsByResourceIds(long uid, ListF<String> resourceIds) {
        return mpfsClient.bulkInfoByResourceIds(MpfsUser.of(uid), Cf.set("pmid"), resourceIds)
                .map(info -> getPreviewUrl(uid, info));
    }

    public String getPreviewUrl(long uid, MpfsFileInfo info) {
        try {
            return mpfsClient.generateZaberunUrl(
                    info.getMeta().getPmid().get(), info.name.get(), "preview", Option.of(uid + ""),
                    Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(),
                    Option.empty(), Option.of("L"), Option.empty(), Option.empty(), Option.of(2000000000),
                    Option.of(0), Option.of(true), Option.empty());
        } catch (Exception e) {
            ExceptionUtils.throwIfUnrecoverable(e);
            logger.error("Failed to get preview {}", e);
            return "";
        }
    }
}
