package ru.yandex.chemodan.app.hackathon;

import ru.yandex.alice.megamind.protos.scenarios.ResponseProto;
import ru.yandex.bolts.collection.Option;

/**
 * @author yashunsky
 */
public class HackatonUtils {
    public static ResponseProto.TScenarioRunResponse createResponse(String divJson, Option<String> textToSpeak) {
        ResponseProto.TLayout.Builder layoutBuilder = ResponseProto.TLayout
                .newBuilder()
                .addCards(ResponseProto.TLayout.TCard
                        .newBuilder()
//                         .setDivCard(builder) see: MEGAMIND-378
                );
        if (textToSpeak.isPresent()) {
            layoutBuilder = layoutBuilder.setOutputSpeech(textToSpeak.get());
        }

        return ResponseProto.TScenarioRunResponse
                .newBuilder()
                .setResponseBody(ResponseProto.TScenarioResponseBody
                        .newBuilder()
                        .setLayout(layoutBuilder
                        ))
                .build();
    }

    public static ResponseProto.TScenarioRunResponse createSimpleTextResponse(String response) {
        return ResponseProto.TScenarioRunResponse
                .newBuilder()
                .setResponseBody(ResponseProto.TScenarioResponseBody
                        .newBuilder()
                        .setLayout(ResponseProto.TLayout
                                .newBuilder()
                                .addCards(ResponseProto.TLayout.TCard
                                        .newBuilder()
                                        .setText(response)
                                )
                                .setOutputSpeech(response)
                        ))
                .build();
    }
}
