package ru.yandex.chemodan.app.hackathon;

import org.springframework.beans.factory.annotation.Autowired;


//import ru.yandex.alice.megamind.protos.scenarios.DirectivesProto;
import ru.yandex.alice.megamind.protos.scenarios.RequestProto;
import ru.yandex.alice.megamind.protos.scenarios.ResponseProto;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.lentaloader.reminder.Cvi2tProcessor;
import ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchFileInfo;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

public class WhatsOnPhotoScenario implements ru.yandex.chemodan.app.hackathon.AliceScenario {
    private static final Logger logger = LoggerFactory.getLogger(WhatsOnPhotoScenario.class);

    private final DynamicProperty<Integer> similarThreshold =
            new DynamicProperty<>("what-similar-threshold", 1000);

    private final DynamicProperty<Integer> matchThreshold =
            new DynamicProperty<>("what-match-threshold", 6000);

    private final DynamicProperty<Integer> maxAttempts =
            new DynamicProperty<>("what-max-attempts", 100);

    private final DivTemplateProcessor templateProcessor = new DivTemplateProcessor("one_photo.ftj");

    @Autowired
    private Cvi2tProcessor cvi2tProcessor;
    @Autowired
    private SearchCache searchCache;
    @Autowired
    private HackatonMpfsClient hackatonMpfsClient;

    public static final String WHATS_ON_PHOTO = "поиграй";
    public static final ListF<String> WORDS = Cf.list("кошка", "собака", "птичка", "велосипед", "самокат", "море", "пляж", "дом", "улица", "город", "рюкзак", "еда", "арбуз", "река", "вода", "праздник", "динозавр", "машина", "трактор", "мотоцикл", "грузовик", "окно", "качели", "шарик", "парк", "горка", "аквапарк", "цветы", "деревья", "хлеб", "торт", "небо", "горы", "самолет", "ежик", "белочка", "лошадка", "лодка", "корабль", "глобус", "книжка", "человек", "девочка", "мальчик", "шляпа", "школа", "дорога", "комната", "окно", "двор", "солнце", "дневник", "тетрадь", "краски", "карандаши", "снег", "елка", "игрушки", "крыша", "светофор", "поезд", "вагон", "чемодан", "дождь", "радуга", "лужа", "мяч", "ягоды", "лопата", "чайник", "маяк");

    private String selectedWord = null;
    private String previewUrl = null;

    @Override
    public int match(ListF<String> text) {
        return text.exists(s -> s.startsWith(WHATS_ON_PHOTO)) ? 10 : 0;
    }

    @Override
    public ResponseProto.TScenarioRunResponse run(long uid, HttpServletRequestX reqX, ListF<String> words,
            RequestProto.TScenarioRunRequest request)
    {
        if (selectedWord != null) {
            return checkResponse(uid, words, request);
        }
        DiskSearchFileInfo photo = null;
        int attempts = 0;
        while (photo == null && attempts < maxAttempts.get()) {
            attempts++;
            selectedWord = Random2.R.randomElement(WORDS);
            photo = getMostMatchingPhoto(uid, selectedWord);
        }
        previewUrl = hackatonMpfsClient.getPreviews(uid, Cf.list(photo)).first();
//        return ResponseProto.TScenarioRunResponse
//                .newBuilder()
//                .setResponseBody(ResponseProto.TScenarioResponseBody
//                        .newBuilder()
//                        .setLayout(ResponseProto.TLayout
//                                .newBuilder()
//                                .addCards(ResponseProto.TLayout.TCard
//                                        .newBuilder()
//                                        .setText(previewUrl + "\n" + "Угадай, что на фото?" + "\nОтвет: " + selectedWord)
//                                )
//                        ))
//                .build();
        ListF<String> variants = Random2.R.randomElements(WORDS, 4).plus(selectedWord).unique().shuffle();
        String divJson = templateProcessor.processTemplate(
                Cf.map("image_url", previewUrl));
        return ResponseProto.TScenarioRunResponse
                .newBuilder()
                .setResponseBody(ResponseProto.TScenarioResponseBody
                        .newBuilder()
                        .setLayout(ResponseProto.TLayout
                                .newBuilder()
                                .addCards(ResponseProto.TLayout.TCard
                                        .newBuilder()
//                                         .setDivCard(divJson) see: MEGAMIND-378
                                )
                                .addCards(ResponseProto.TLayout.TCard
                                        .newBuilder()
                                        .setTextWithButtons(ResponseProto.TLayout.TTextWithButtons
                                                .newBuilder()
                                                .setText("Угадай, что на фото?")
                                                .addAllButtons(variants.map(s -> ResponseProto.TLayout.TButton
                                                        .newBuilder()
                                                        .setTitle(s)
                                                        //.addDirectives(DirectivesProto.TDirective
                                                        //      .newBuilder()
                                                        //    .setTypeTextDirective(DirectivesProto.TTypeTextDirective.newBuilder()
                                                        //          .setName(s)
                                                        //        .setText(s)
                                                        //      .build())
                                                        // )
                                                .build()
                                                ))
                                        )
                                )
                                .setOutputSpeech("Угадай, что на фото?")
                        ))
                .build();
    }

    private ResponseProto.TScenarioRunResponse checkResponse(long uidL, ListF<String> words, RequestProto.TScenarioRunRequest request) {
        if (selectedWord.toLowerCase().equals(request.getInput().getText().getUtterance().toLowerCase())) {
            selectedWord = null;
            previewUrl = null;
            return HackatonUtils.createSimpleTextResponse("Ты угадал!");
        } else {
            ListF<String> variants = Random2.R.randomElements(WORDS, 4).plus(selectedWord).unique().shuffle();
            String divJson = templateProcessor.processTemplate(
                    Cf.map("image_url", previewUrl));
            return ResponseProto.TScenarioRunResponse
                    .newBuilder()
                    .setResponseBody(ResponseProto.TScenarioResponseBody
                            .newBuilder()
                            .setLayout(ResponseProto.TLayout
                                    .newBuilder()
                                    .addCards(ResponseProto.TLayout.TCard
                                            .newBuilder()
//                                             .setDivCard(divJson) see: MEGAMIND-378
                                    )
                                    .addCards(ResponseProto.TLayout.TCard
                                            .newBuilder()
                                            .setTextWithButtons(ResponseProto.TLayout.TTextWithButtons
                                                    .newBuilder()
                                                    .setText("Попробуй еще")
                                                    .addAllButtons(variants.map(s -> ResponseProto.TLayout.TButton
                                                            .newBuilder()
                                                            .setTitle(s)
                                                            //.addDirectives(DirectivesProto.TDirective
                                                            //        .newBuilder()
                                                            //        .setTypeTextDirective(DirectivesProto.TTypeTextDirective.newBuilder()
                                                            //                .setName(s)
                                                            //                .setText(s)
                                                            //                .build())
                                                            //)
                                                    .build()
                                                    ))
                                            )
                                    )
                                    .setOutputSpeech("Попробуй еще")
                            ))
                    .build();
        }
    }

    public DiskSearchFileInfo getMostMatchingPhoto(long uid, String word) {
        ListF<DiskSearchFileInfo> photos = searchCache.getAllPhotos(uid)
                .filter(photo -> photo.beautiful2.exists(beauty -> beauty >= -2))
                .take(30000)
                .zipWith(info -> cvi2tProcessor.dotProduct(info.geti2tVector(), word))
                .filter(tuple -> tuple._2 > matchThreshold.get())
                .filter(tuple -> Math.abs(cvi2tProcessor.dotProduct(tuple._1, WORDS.filterNot(e->e.equals(word))).sorted().reverse().first() - tuple._2) > similarThreshold.get())
                .sortedBy2Desc()
                .get1();
        if (photos.length() == 0) {
            return null;
        }

        return Random2.R.randomElement(photos.take(20));
    }

    @Override
    public boolean isActive() {
        return selectedWord != null;
    }

    @Override
    public void forceDeactivate() {
        selectedWord = null;
    }
}
