package ru.yandex.chemodan.office.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.time.Duration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.tf.se.adapter.AdapterMessageException;
import com.tf.se.adapter.impl.AbstractAdapterG3;
import com.tf.se.adapter.impl.TFSIReleaseCallbackWithInputStream;
import com.tf.se.adapter.vo.TFSIFileVO;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.CookieSpecs;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

/**
 * @author tolmalev
 */
public class Disk8Adapter extends AbstractAdapterG3 {

    private static final String mpfsHost = "http://mpfs.disk.yandex.net";
    private static final int mpfsConnectTimeout = 100;
    private static final int mpfsSocketTimeout = (int) Duration.ofSeconds(5).toMillis();

    private static final int uploadConnectTimeout = 1000;
    private static final int uploadSocketTimeout = (int) Duration.ofSeconds(60).toMillis();

    private static final int fileReadTimeout = (int) Duration.ofSeconds(5).toMillis();
    private static final int fileConnectTimeout = (int) Duration.ofSeconds(1).toMillis();

    private static final long serialVersionUID = -64530143845684823L;
    private static final HttpClient mpfsHttpClient = buildHttpClient(mpfsConnectTimeout, mpfsSocketTimeout);
    private static final HttpClient putHttpClient = buildHttpClient(uploadConnectTimeout, uploadSocketTimeout);

    private static final ResponseHandler<JsonNode> readJsonNodeHandler = response -> {
        if (response.getStatusLine().getStatusCode() != 200) {
            log("Status code from mpfs: " + response.getStatusLine().getStatusCode());
            return null;
        }

        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(response.getEntity().getContent());
    };

    private String fid = "";
    private String uid = "";

    private static void log(String message) {
        //TODO: use some logging framework
        System.out.println(message);
    }

    @Override
    public boolean start(HttpServletRequest request, HttpServletResponse response, String s)
            throws AdapterMessageException
    {
        fid = request.getParameter("fid");
        uid = request.getParameter("uid");

        //TODO: check auth here
        return true;
    }

    @Override
    public TFSIFileVO info(String path, String connid) throws AdapterMessageException {
        JsonNode json = getFileInfoJson(uid, path);

        TFSIFileVO info = new TFSIFileVO();
        info.setName(json.get("name").getTextValue());
        info.setType("dir".equals(json.get("type").getTextValue()) ? TYPE_FOLDER : TYPE_FILE);
        //TODO: set right access type
        info.setRead(true);
        info.setWrite(true);
        return info;
    }

    @Override
    public TFSIReleaseCallbackWithInputStream get(String path) throws AdapterMessageException {
        JsonNode json = getFileInfoJson(uid, path);
        String fileUrl = json.get("meta").get("file_url").getTextValue();

        log("File content URL: " + fileUrl);

        try {
            HttpURLConnection conn = (HttpURLConnection) new URL(fileUrl).openConnection();
            conn.setReadTimeout(fileReadTimeout);
            conn.setConnectTimeout(fileConnectTimeout);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);

            final HttpURLConnection conn2 = conn;
            return new TFSIReleaseCallbackWithInputStream(conn2.getInputStream()) {
                @Override
                public void release() {
                    conn2.disconnect();
                }
            };
        } catch (Exception e) {
            throw new RuntimeException("Failed to get file content", e);
        }
    }

    @Override
    public String put(String path, InputStream inputStream, long l) throws AdapterMessageException {
        try {
            URI uri = new URIBuilder(mpfsHost)
                    .setPath("/json/store")
                    .addParameter("uid", uid)
                    .addParameter("path", path)
                    .addParameter("force", "1")
                    .build();

            log("Make store request: " + uri);

            String uploadUrl = executeAndGetJson(new HttpGet(uri)).get("upload_url").asText();
            log("Upload URL: " + uploadUrl);

            HttpPut request = new HttpPut(uploadUrl);
            request.setEntity(new InputStreamEntity(inputStream));

            putHttpClient.execute(request, new ResponseHandler<Void>() {
                @Override
                public Void handleResponse(HttpResponse response) throws IOException {
                    int code = response.getStatusLine().getStatusCode();
                    log("Store status code = " + code);
                    if (code == 200 || code == 201) {
                        return null;
                    }
                    throw new RuntimeException("Bad status code: " + code);
                }
            });

            log("Store finished OK");

            return getFileInfoJson(uid, path).get("meta").get("file_id").asText();
        } catch (Exception e) {
            throw new RuntimeException("Failed to get file info from mpfs", e);
        }
    }

    @Override
    public boolean lock(String s, String s1) throws AdapterMessageException {
        //TODO: implement
        return true;
    }

    @Override
    public boolean unlock(String s, String s1) throws AdapterMessageException {
        //TODO: implement
        return true;
    }

    private static JsonNode executeAndGetJson(HttpGet request) {
        try {
            return mpfsHttpClient.execute(request, readJsonNodeHandler);
        } catch (IOException e) {
            throw new RuntimeException("Failed to get file info from mpfs", e);
        }
    }

    private static JsonNode getFileInfoJson(String uid, String path) {
        try {
            URI uri = new URIBuilder(mpfsHost)
                    .setPath("/json/info")
                    .addParameter("uid", uid)
                    .addParameter("path", path)
                    .addParameter("meta", "")
                    .build();

            log("Make info request: " + uri);

            return executeAndGetJson(new HttpGet(uri));
        } catch (Exception e) {
            throw new RuntimeException("Failed to get file info from mpfs", e);
        }
    }

    private static HttpClient buildHttpClient(int connectTimeout, int socketTimeout) {

        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setStaleConnectionCheckEnabled(true);
        requestConfigBuilder.setCookieSpec(CookieSpecs.BROWSER_COMPATIBILITY);

        requestConfigBuilder.setConnectTimeout(connectTimeout);
        requestConfigBuilder.setConnectionRequestTimeout(connectTimeout);
        requestConfigBuilder.setSocketTimeout(socketTimeout);

        RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.<ConnectionSocketFactory>create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", SSLConnectionSocketFactory.getSocketFactory());

        PoolingHttpClientConnectionManager connectionManager =
                new PoolingHttpClientConnectionManager(registryBuilder.build());

        connectionManager.setDefaultMaxPerRoute(100);
        connectionManager.setMaxTotal(100);

        return HttpClientBuilder
                .create()
                .setConnectionManager(connectionManager)
                .disableRedirectHandling()
                .setDefaultRequestConfig(requestConfigBuilder.build())
                .build();
    }

    @Override
    public boolean stop() throws AdapterMessageException {
        //TODO: what should we do here?
        return true;
    }

    @Override
    public Object list(String s) throws AdapterMessageException {
        return null;
    }

    @Override
    public boolean mkdir(String s, String s1) throws AdapterMessageException {
        return true;
    }

    @Override
    public boolean rename(String s, String s1) throws AdapterMessageException {
        return true;
    }

    @Override
    public boolean delete(String s) throws AdapterMessageException {
        return true;
    }

    @Override
    public int level() throws AdapterMessageException {
        return LEVEL_4;
    }

    @Override
    public String author() throws AdapterMessageException {
        return "Yandex.Disk Team";
    }
}
