package ru.yandex.chemodan.office.adapter2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Installed logger's doesn't show thread name
 */
public class Log {

    private final Logger logger;

    public Log(Class aClass) {
        logger = Logger.getLogger(aClass.getName());
        logger.setLevel(Level.ALL);
        logger.info("log inited");
    }

    public void info(String message, Object ... param) {
        logger.info(log(message, param));
    }

    public void warn(String message, Object ... param) {
        logger.warning(log(message, param));
    }

    public String log(String message, Object ... param) {
        Object[] args = Arrays.stream(param).map(s -> {
            if (s instanceof Throwable) {
                return getStackTrace((Throwable) s);
            } else {
                return Objects.toString(s);
            }
        }).toArray();
        Formatter formatter = new Formatter();
        String s = formatter.format(message.replace("{}", "%s") + "%n", args).toString();
        System.out.println(s);
        return s;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw, true);
        throwable.printStackTrace(pw);
        return throwable.getMessage() + "; " + sw.getBuffer().toString();
    }
}
