#!/bin/bash -e

# TODO: move functions to install-package.sh when all disk projects will be migrated to Ubuntu

err_exit() {
    echo "$@" >&2
    exit 1
}

ec() {
    echo "$@"
    "$@"
}

install_package() {
    PACKAGE="$1"
    PROJECT="$2"
    APP="$3"
    DESTDIR="$4"

    USER=disk
    GROUP=disk
    if [ $MODULE = "log-reader" ] \
        || [ $MODULE = "worker" ] \
        || [ $MODULE = "worker2" ] \
        || [ $MODULE = "download-stat" ] \
        || [ $MODULE = "event-loader" ]; \
    then
        USER=nginx
        GROUP=nginx
    fi

    MODULE_DIR=$PROJECT/$MODULE
    Y_MODULE_DIR=yandex/$MODULE_DIR

    test -n "$PACKAGE" -a -n "$PROJECT" -a -n "$APP" -a -n "$DESTDIR" || err_exit "usage $0 <package> <project> <app> <destdir>"

    ec install -d $DESTDIR/etc/logrotate.d/
    ec install -d $DESTDIR/var/log/yandex/$PROJECT/
    ec install -d $DESTDIR/var/tmp/yandex/$PROJECT/$APP/

    # Logrotate
    LOGROTATE_CONF_PATH=$DESTDIR/etc/logrotate.d/yandex-disk-$MODULE.conf
    if [ -f ./devel/etc/logrotate.d/yandex-disk-$MODULE.conf ]; then
        cat ./devel/etc/logrotate.d/yandex-disk-$MODULE.conf >$LOGROTATE_CONF_PATH
        chmod 644 $LOGROTATE_CONF_PATH
    fi

    # .postinst
    cat debian/postinst.template \
        | sed "s,@PROJECT@,$PROJECT,g" \
        | sed "s,@APP@,$APP,g" \
        | sed '1 a\# This file is generated. Do not edit!' \
        > debian/$PACKAGE.postinst

	# Properties
	PROP_DIR=$DESTDIR/etc/$Y_MODULE_DIR
	mkdir -p $PROP_DIR
	touch $PROP_DIR/application.properties
	chmod 644 $PROP_DIR/application.properties
	for f in support/common/src/main/java/ru/yandex/chemodan/global/application-{default,development,testing,prestable,production}.properties; do
		PROP_FILE=$PROP_DIR/`basename $f`
		echo "#" > $PROP_FILE
		echo "# DO NOT EDIT THIS FILE, edit /etc/$Y_MODULE_DIR/application.properties instead" >> $PROP_FILE
		echo "#" >> $PROP_FILE
		cat $f >> $PROP_FILE
		chmod 600 $PROP_FILE
	done

    # Hack
    mkdir -p $DESTDIR/DEBIAN

    if [ "$MODULE" = "logs-cron" ]; then
        ec install -d $DESTDIR/etc/cron.d/
        ec install -d $DESTDIR/usr/bin/
        ec install -m755 common/src/main/etc/yandex-disk-logs-cron.cron $DESTDIR/etc/cron.d/yandex-disk-logs-cron
        ec install -m755 common/src/main/bin/moderation-queue.sh $DESTDIR/usr/bin/moderation-queue.sh
        ec install -m755 common/src/main/bin/put-to-moderation-queue.py $DESTDIR/usr/bin/put-to-moderation-queue.py
        ec install -m755 common/src/main/bin/moderation-queue.py $DESTDIR/usr/bin/moderation-queue.py
        ec install -m755 common/src/main/bin/infected-files.sh $DESTDIR/usr/bin/infected-files.sh
        ec install -m755 common/src/main/bin/read-disk-property $DESTDIR/usr/bin/read-disk-property
        return
    fi

    ec install -d $DESTDIR/etc/yandex/$PROJECT/$APP/
    ec install -d $DESTDIR/etc/init.d/
    ec install -d $DESTDIR/etc/nginx/sites-enabled/
    ec install -d $DESTDIR/var/lib/yandex/$PROJECT/
    ec install -d $DESTDIR/var/run/yandex/$PROJECT/
    ec install -d $DESTDIR/var/spool/yandex/$PROJECT/$APP/
    ec install -d $DESTDIR/var/spool/yandex/$PROJECT/$APP/tmp
    ec install -d $DESTDIR/usr/lib/yandex/$PROJECT/$APP/lib/
    ec install -d $DESTDIR/usr/lib/yandex/$PROJECT/$APP/bin/
    ec install -d $DESTDIR/usr/lib/yandex/$PROJECT/$APP/bin/include
    ec install -d $DESTDIR/usr/bin/yandex/$PROJECT/

    if [ "$MODULE" = "uploader" ]; then
        ec install -d $DESTDIR/u0/$MODULE_DIR/tmp/
        ec install -d $DESTDIR/u0/$MODULE_DIR/local-files/
        ec install -d $DESTDIR/u0/$MODULE_DIR/queue/done
        ec install -d $DESTDIR/u0/$MODULE_DIR/queue/failed
        ec install -d $DESTDIR/u0/$MODULE_DIR/queue/processing
        for SUBFOLDER_INDEX in `seq -w 0 255`; do
            ec install -d $DESTDIR/u0/$MODULE_DIR/queue/processing/$SUBFOLDER_INDEX
        done
        ec install -d $DESTDIR/etc/$Y_MODULE_DIR/keys/
        ec install -d $DESTDIR/etc/$Y_MODULE_DIR/crossdomain/
        ec install -d $DESTDIR/usr/share/doc/$PACKAGE/conf
        ec install -d $DESTDIR/usr/share/$PACKAGE

        ec install -m644 common/src/main/share/*.png $DESTDIR/usr/share/$PACKAGE
        ec install -m755 common/src/main/bin/kqueue.sh $DESTDIR/usr/bin/kladun-kqueue.sh
        ec install -m755 common/src/main/bin/detect-active-network-interface.sh $DESTDIR/usr/bin/detect-active-network-interface.sh

        for f in common/src/main/etc/crossdomain/crossdomain-{development,testing,production}.xml; do
            ec install -m644 $f $DESTDIR/etc/$Y_MODULE_DIR/crossdomain/
        done
    fi

    # Copy include files from YANDEX_BUILD
    ec install -m755 $YANDEX_BUILD/java/include/* $DESTDIR/usr/lib/yandex/$PROJECT/$APP/bin/include

    # Ubic and init script
    ./install-ubic-config.sh $DESTDIR/etc/ubic/service $PROJECT $APP
    ec install -m755 debian/init-d.template $DESTDIR/etc/init.d/$PACKAGE

    # Jars
    ec install -m644 ./common/target/jars/* $DESTDIR/usr/lib/yandex/$PROJECT/$APP/lib/
    ec install -m644 ./common/lib/runtime/* $DESTDIR/usr/lib/yandex/$PROJECT/$APP/lib/

    #nginx config
    ec install -m644 ./common/src/main/etc/22-disk-proxy-to-services.conf $DESTDIR/etc/nginx/sites-enabled/$PACKAGE.conf
    ec install -m644 ./common/src/main/etc/solomon/nginx-proxy-for-solomon.conf $DESTDIR/etc/nginx/sites-enabled/$PACKAGE-proxy-for-solomon.conf

	install -d $DESTDIR/etc/monrun/conf.d/
	install -m755 common/src/main/etc/monrun/conf.d/$APP.conf $DESTDIR/etc/monrun/conf.d/
}

for PROJECT_MODULE in `cat debian/control | sed -n -e 's/Package: yandex-//p'`; do
    PROJECT=disk
    MODULE=${PROJECT_MODULE#*-}
    if [ "$MODULE" = "dataapi" ] || [ "$MODULE" = "dataapi-worker" ] || [ "$MODULE" = "datasync-admin" ]; then
        PROJECT=dataapi
    fi
    PACKAGE="yandex-$PROJECT_MODULE"
    DESTDIR="debian/$PACKAGE"
    echo "installing module $MODULE for Debian"
    echo "project=$PROJECT, module=$MODULE, package=$PACKAGE, destdir=$DESTDIR"
    rm -rf "$DESTDIR"
    mkdir -p "$DESTDIR"
    install_package "$PACKAGE" "$PROJECT" "$MODULE" "$DESTDIR"
done

# vim: set ts=4 sw=4 et:

