#!/bin/sh -e

err_exit() {
    echo "$@" >&2
    exit 1
}

destdir="$1"
[ -z "$destdir" ] && err_exit "destdir is undefined"

project="$2"
[ -z "$project" ] && err_exit "project is undefined"

app="$3"
[ -z "$app" ] && err_exit "app is undefined"

etc_dir=/etc/yandex/$project/$app
lib_dir=/usr/lib/yandex/$project/$app
var_log_dir=/var/log/yandex/$project
var_run_dir=/var/run/yandex/$project
var_tmp_dir=/var/tmp/yandex/$project/$app
java_io_tmp_dir=/var/spool/yandex/$project/$app/tmp

if [ "$app" = uploader ]; then
  var_tmp_dir=/u0/$project/$app/tmp
  java_io_tmp_dir=$var_tmp_dir
else
  var_tmp_dir=/var/tmp/yandex/$project/$app
  java_io_tmp_dir=/var/spool/yandex/$project/$app/tmp
fi

library_path=-Djava.library.path=$lib_dir/lib/

base_mem_params="-Xms256m -XX:MaxMetaspaceSize=256m"
testing_mem_params="$base_mem_params -Xmx1g"

xmx_development=1g

if [ "$app" = download-stat ]; then
  main_class=ru.yandex.chemodan.app.stat.DiskStatMain
  library_path=$library_path:/usr/lib/geobase4
  xmx=1g
  testing_mem_params="-Xms128m -XX:MaxMetaspaceSize=128m -Xmx512m"
elif [ "$app" = log-reader ]; then
  main_class=ru.yandex.chemodan.app.logreader.MpfsLogReaderMain
  xmx=1g
  testing_mem_params="-Xms128m -XX:MaxMetaspaceSize=128m -Xmx512m"
elif [ "$app" = uploader-balancer ]; then
  main_class=ru.yandex.chemodan.app.balancer.BalancerMain
  xmx=1g
elif [ "$app" = worker2 ]; then
  main_class=ru.yandex.chemodan.app.worker2.Worker2Main
  xmx=3g
  testing_mem_params="-Xms128m -XX:MaxMetaspaceSize=128m -Xmx512m"
elif [ "$app" = uploader ]; then
  main_class=ru.yandex.chemodan.uploader.UploaderMain
  xmx=8g
elif [ "$app" = dataapi ]; then
  main_class=ru.yandex.chemodan.app.dataapi.DataApiMain
  xmx=4g
elif [ "$app" = counters-api ]; then
  main_class=ru.yandex.chemodan.app.countersapi.CountersApiMain
  xmx=4g
elif [ "$app" = "dataapi-worker" ]; then
  main_class=ru.yandex.chemodan.app.dataapi.worker.DataApiWorkerMain
  xmx=4g
elif [ "$app" = "smartcache-worker" ]; then
  main_class=ru.yandex.chemodan.app.smartcache.worker.SmartCacheWorkerMain
  library_path=$library_path:/usr/lib/geobase4
  xmx=4g
  xmx_development=512m
elif [ "$app" = "smartcache-client" ]; then
  main_class=ru.yandex.chemodan.app.smartcache.client.SmartCacheClientMain
  xmx=4g
  xmx_development=256m
elif [ "$app" = "event-loader" ]; then
  main_class=ru.yandex.chemodan.app.eventloader.EventLoaderMain
  xmx=1g
  testing_mem_params="-Xms128m -XX:MaxMetaspaceSize=128m -Xmx512m"
elif [ "$app" = "lenta-loader" ]; then
  main_class=ru.yandex.chemodan.app.lentaloader.LentaLoaderMain
  xmx=2g
elif [ "$app" = "lenta-worker" ]; then
  main_class=ru.yandex.chemodan.app.lentaworker.LentaWorkerMain
  xmx=2g
elif [ "$app" = "monica" ]; then
  main_class=ru.yandex.chemodan.app.monica.MonicaMain
  xmx=2g
  testing_mem_params="-Xms128m -XX:MaxMetaspaceSize=128m -Xmx512m"
elif [ "$app" = "comments" ]; then
  main_class=ru.yandex.chemodan.app.commentaries.CommentsMain
  xmx=2g
elif [ "$app" = "queller" ]; then
  main_class=ru.yandex.chemodan.app.queller.QuellerMain
  xmx=4g
  xmx_development=512m
elif [ "$app" = "notifier" ]; then
  main_class=ru.yandex.chemodan.app.notifier.client.NotifierMain
  xmx=1g
  xmx_development=512m
elif [ "$app" = "urlshortener" ]; then
  main_class=ru.yandex.chemodan.app.urlshortener.UrlShortenerMain
  xmx=1g
  xmx_development=512m
elif [ "$app" = "factapi" ]; then
  main_class=ru.yandex.chemodan.app.persapi.FactApiMain
  xmx=1g
  xmx_development=512m
elif [ "$app" = "factprocessor" ]; then
  main_class=ru.yandex.chemodan.app.factprocessor.FactProcessorMain
  xmx=1g
  xmx_development=512m
elif [ "$app" = "datasync-admin" ]; then
  main_class=ru.yandex.chemodan.app.datasyncadmin.DataSyncAdminMain
  xmx=1g
  xmx_development=512m
elif [ "$app" = "webdav" ]; then
  main_class=ru.yandex.chemodan.app.webdav.WebDavMain
  xmx=1g
  xmx_development=512m
else
  err_exit "don't know main_class for app $app"
fi

rel_properties_file="src/main/java/ru/yandex/chemodan/global/application-default.properties"
properties_file="./support/common/$rel_properties_file"

check_port=$(sed -n "/^$app.admin.http.port/s/^.*=//p" "$properties_file")
debug_port=$(sed -n "/java.$app.debug.port/s/^.*=//p" "$properties_file")

if [ -z "$debug_port" ]; then
    for properties_file in $( find .  -name "*-default.properties" -type f ); do
        [ -z $check_port ] && check_port=$(sed -n "/^$app.admin.http.port/s/^.*=//p" "$properties_file")
        [ -z $debug_port ] && debug_port=$(sed -n "/java.$app.debug.port/s/^.*=//p" "$properties_file")
    done
fi

[ -z $debug_port ] && err_exit "debug_port is undefined"
[ -z $check_port ] && err_exit "check_port is undefined"

if [ "$app" = log-reader ] \
    || [ "$app" = worker ] \
    || [ "$app" = worker2 ] \
    || [ "$app" = download-stat ] \
    || [ "$app" = event-loader ] ; \
then
  user=nginx
elif [ "$app" = factapi ] \
         || [ "$app" = factprocessor ] ; \
then
  user=axis
else
  user=disk
fi

uid="chuid = $user:$user"

java_path=/usr/local/java8/bin/java

if [ "$app" = uploader ] ; then
    java_args_network=""
else
    java_args_network="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true -Djava.security.egd=file:/dev/./urandom"
fi


if [ "$app" = worker ] \
    || [ "$app" = worker2 ] \
    || [ "$app" = dataapi ] \
    || [ "$app" = download-stat ] \
    || [ "$app" = comments ] \
    || [ "$app" = lenta-loader ] \
    || [ "$app" = lenta-worker ] \
    || [ "$app" = event-loader ] ; \
then
    java_args_gc="-XX:+UseG1GC -XX:MaxGCPauseMillis=75 -XX:+ParallelRefProcEnabled -XX:-UseGCOverheadLimit"
else
    java_args_gc="-XX:+UseParallelGC -XX:+UseParallelOldGC -XX:-UseGCOverheadLimit"
fi

val="module = Media::JavaUbic

[options]

ulimits = ulimit -n 20480

shell = sh -c

$invoker_config_env_var

$uid

java_path = $java_path

exit_on_oom = 1

check_retries = 20

check_port = $check_port

wait_before_term = 10
wait_before_term@development = 5

main_class = $main_class

classpath = $lib_dir/lib/*

java_args_0 = -Dapp=$app -Dapp.var.dir=/var/lib/yandex/$project/$app

java_args_library=$library_path
java_args_jna=-Djna.library.path=$lib_dir/lib/

java_args_direct = -XX:MaxDirectMemorySize=128m

java_args_log4j2 = -DLog4jContextSelector=org.apache.logging.log4j.core.async.AsyncLoggerContextSelector -Dlog4j2.enable.threadlocals=true -Dlog4j2.enable.direct.encoders=true -DAsyncLogger.WaitStrategy=$log4j_waitStrategy

java_args_mem = $base_mem_params -Xmx$xmx
java_args_mem@development = $base_mem_params -Xmx$xmx_development
java_args_mem@testing = $testing_mem_params

java_args_gc = $java_args_gc \
-XX:+PrintGCApplicationStoppedTime -XX:+PrintGCDateStamps \
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=10M \
-Xloggc:$var_log_dir/$app.gc.log

java_args_network = $java_args_network
java_args_network@testing=-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true

java_args_debug@development = -Xdebug -Xnoagent -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=$debug_port
java_args_debug@testing = -Xdebug -Xnoagent -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=$debug_port

java_args = -showversion -server \
-XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=$var_tmp_dir \
-Djava.io.tmpdir=$java_io_tmp_dir -Dfile.encoding=UTF-8 \
-Dnetworkaddress.cache.ttl=600 \
-Dsun.net.client.defaultConnectTimeout=5000 -Dsun.net.client.defaultReadTimeout=5000 \
-Dproject=$project"

mkdir -p $destdir
file=$destdir/yandex-disk-$app.ini
echo "$val" >$file
chmod 644 $file

# vim: set ts=4 sw=4 et:

