package ru.yandex.chemodan.app.lentaloader;

import java.util.function.Supplier;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyStaticRegistry;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.random.Random2;

/**
 * @author dbrylev
 */
public class DynamicVars {

    public static final DynamicProperty<Boolean> nowaitLockForCreatureInsert = new DynamicProperty<>(
            "lenta-nowait-lock-creature-insert", false);

    public static final DynamicProperty<Boolean> nowaitLockForCreatureMerge = new DynamicProperty<>(
            "lenta-nowait-lock-creature-merge", false);

    public static final DynamicProperty<Boolean> nowaitLockForBlockInsert = new DynamicProperty<>(
            "lenta-nowait-lock-block-insert", false);

    public static final DynamicProperty<Boolean> nowaitLockForBlockModify = new DynamicProperty<>(
            "lenta-nowait-lock-block-modify", false);

    public static final DynamicProperty<Boolean> nowaitLockForBlockModifyAsync = new DynamicProperty<>(
            "lenta-nowait-lock-block-modify-async", false);

    public static final DynamicProperty<Boolean> nowaitLockForBlockUpdateInplace = new DynamicProperty<>(
            "lenta-nowait-lock-block-update-inplace", false);

    public static final DynamicProperty<Boolean> nowaitLockForBlockMerge = new DynamicProperty<>(
            "lenta-nowait-lock-block-merge", false);

    public static final DynamicProperty<Boolean> exclusiveLockForBlockMerge = new DynamicProperty<>(
            "lenta-exclusive-lock-block-merge", true);


    private static final DynamicProperty<Integer> blockPinTtlSeconds = new DynamicProperty<>(
            "lenta-block-pin-ttl-seconds", (int) Duration.standardDays(1).getStandardSeconds());

    public static final Supplier<Duration> blockPinTtl = fromSecondsSupplier(blockPinTtlSeconds);


    private static final DynamicProperty<Integer> blockUpdateDelaySeconds = new DynamicProperty<>(
            "lenta-block-update-delay-seconds", (int) Duration.standardMinutes(5).getStandardSeconds());

    private static final DynamicProperty<Integer> blockDeleteDelaySeconds = new DynamicProperty<>(
            "lenta-block-delete-delay-seconds", 0);

    private static final DynamicProperty<Integer> blockDeleteDelaySecondsRandom = new DynamicProperty<>(
            "lenta-block-delete-delay-random-seconds", 10);

    private static final DynamicProperty<Integer> blockUpdateInplaceRetryDelaySeconds = new DynamicProperty<>(
            "lenta-block-update-inplace-retry-delay-seconds", 30);

    public static final Supplier<Duration> blockUpdateDelay = fromSecondsSupplier(blockUpdateDelaySeconds);

    public static final Supplier<Duration> blockDeleteDelay = fromSecondsSupplier(blockDeleteDelaySeconds);

    public static final Supplier<Duration> blockDeleteDelayRandom =
            fromMsSupplierRandom(blockDeleteDelaySecondsRandom);

    public static final Supplier<Duration> blockUpdateInplaceRetryDelay =
            fromSecondsSupplier(blockUpdateInplaceRetryDelaySeconds);


    private static final DynamicProperty<Integer> blocksFindAndModifyDelaySec = new DynamicProperty<>(
            "lenta-blocks-find-and-modify-delay-seconds", (int) Duration.standardMinutes(5).getStandardSeconds());

    private static final DynamicProperty<Integer> blocksFindAndModifyGapSec = new DynamicProperty<>(
            "lenta-blocks-find-and-modify-gap-seconds", 15);

    public static final Supplier<Duration> blocksFindAndModifyDelay = fromSecondsSupplier(blocksFindAndModifyDelaySec);

    public static final Supplier<Duration> blocksFindAndModifyGap = fromSecondsSupplier(blocksFindAndModifyGapSec);


    private static final DynamicProperty<Integer> contentCreatureTtlSeconds = new DynamicProperty<>(
            "lenta-content-creature-ttl-seconds", (int) Duration.standardDays(1).getStandardSeconds());

    private static final DynamicProperty<Integer> contentMergeDelaySeconds = new DynamicProperty<>(
            "lenta-content-merge-delay-seconds", (int) Duration.standardMinutes(1).getStandardSeconds());

    public static final Supplier<Duration> contentCreatureTtl = fromSecondsSupplier(contentCreatureTtlSeconds);

    public static final Supplier<Duration> contentMergeDelay = fromSecondsSupplier(contentMergeDelaySeconds);


    public static final DynamicProperty<ListF<Integer>> contentPathLevelLimits = new DynamicProperty<>(
            "lenta-content-path-level-limits", Cf.list(300, 100, 50, 20, 10));

    public static final DynamicProperty<CleanupBlocksConfiguration> cleanupBlocksTaskConf = new DynamicProperty<>(
            "lenta-cleanup-blocks-task-configuration", new CleanupBlocksConfiguration(10_000, 9_800));

    public static final DynamicProperty<CleanupBlocksConfiguration> cleanupBlocksInplaceConf = new DynamicProperty<>(
            "lenta-cleanup-blocks-inplace-configuration", new CleanupBlocksConfiguration(10_000, 9_900));

    public static final DynamicProperty<Integer> fakeProcessingTime = new DynamicProperty<>(
            "lenta-fake-line-processing-time", 0);

    public static final DynamicProperty<ListF<String>> mpfsShareUids = new DynamicProperty<>(
            "lenta-mpfs-share-uids", Cf.list("share_production")
    );

    private static final DynamicProperty<Integer> notifierPushDeviceDelaySeconds = new DynamicProperty<>(
            "notifier-push-device-delay-seconds", (int) Duration.standardDays(1).getStandardSeconds());

    public static final DynamicProperty<ListF<Long>> disableBlockUids =
            new DynamicProperty<>("lenta-disable-block-uids", Cf.list(50273844L, 27298901L, 434144449L));
    public static final DynamicProperty<ListF<String>> disableBlockTypes =
            new DynamicProperty<>("lenta-disable-block-types", Cf.list("public_resource", "public_resource_owned"));


    public static final Supplier<Duration> notifierPushDeviceDelay = fromSecondsSupplier(notifierPushDeviceDelaySeconds);

    static {
        DynamicPropertyStaticRegistry.addStaticFields(DynamicVars.class);
    }

    @BenderBindAllFields
    public static class CleanupBlocksConfiguration {
        public final int blocksSearchLimit;
        public final int blocksEnough;

        public CleanupBlocksConfiguration(int blocksSearchLimit, int blocksEnough) {
            this.blocksSearchLimit = blocksSearchLimit;
            this.blocksEnough = blocksEnough;
        }
    }

    private static Supplier<Duration> fromSecondsSupplier(DynamicProperty<Integer> dp) {
        return fromSecondsSupplier(dp.get());
    }

    private static Supplier<Duration> fromSecondsSupplier(Integer delay) {
        return () -> Duration.standardSeconds(delay);
    }

    private static Supplier<Duration> fromMsSupplierRandom(DynamicProperty<Integer> dp) {
        return fromMsSupplier(Random2.R.nextInt(dp.get() * 10) * 100); //We operate 100 of Ms
    }

    private static Supplier<Duration> fromMsSupplier(Integer delay) {
        return () -> Duration.millis(delay);
    }

}
