package ru.yandex.chemodan.app.lentaloader;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

import ru.yandex.chemodan.eventlog.MetricsEventLogListener;
import ru.yandex.chemodan.eventlog.log.TskvClientMetricsEventLogLine;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.logbroker.pull.consumer.LbLineListener;
import ru.yandex.inside.logbroker.pull.model.LbMessageMetadata;

public class LbMetricsEventLineListener implements LbLineListener {

    private static final String EVENT_TYPE_SEARCH_PATTERN = String.format("\t%s=", TskvClientMetricsEventLogLine.EVENT_TYPE);

    private final DynamicProperty<Boolean> enableDefaultListener = new DynamicProperty<>("cool-lenta-metrics-event-default-event-enable", true);

    private final MetricsEventLogListener metricsEventLogListener;

    private final LbLineListener defaultListener;

    private final ExecutorService executorService;

    public LbMetricsEventLineListener(MetricsEventLogListener metricsEventLogListener, LbLineListener lbLineListener,
            ExecutorService executorService) {
        this.metricsEventLogListener = metricsEventLogListener;
        this.defaultListener = lbLineListener;
        this.executorService = executorService;
    }

    @Override
    public CompletableFuture<Void> processLogLine(String line, int lineNumber, LbMessageMetadata metadata) {
        if (line.contains(EVENT_TYPE_SEARCH_PATTERN)) {
            return CompletableFuture.runAsync(() -> metricsEventLogListener.processLogLine(line), executorService);
        }
        if (enableDefaultListener.get()) {
            return defaultListener.processLogLine(line, lineNumber, metadata);
        }
        return CompletableFuture.completedFuture(null);
    }
}
